/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.opensearch.client.util.ObjectBuilder;

public interface TransportOptions {
    public Collection<Map.Entry<String, String>> headers();

    public Map<String, String> queryParameters();

    public Function<List<String>, Boolean> onWarnings();

    public Builder toBuilder();

    default public TransportOptions with(Consumer<Builder> fn) {
        Builder builder = this.toBuilder();
        fn.accept(builder);
        return (TransportOptions)builder.build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static class DefaultImpl
    implements TransportOptions {
        private final List<Map.Entry<String, String>> headers;
        private final Map<String, String> params;
        private final Function<List<String>, Boolean> onWarnings;

        protected DefaultImpl(BuilderImpl builder) {
            this.headers = builder.headers.isEmpty() ? Collections.emptyList() : new ArrayList<Map.Entry<String, String>>(builder.headers);
            this.params = builder.queryParameters.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(builder.queryParameters);
            this.onWarnings = builder.onWarnings;
        }

        @Override
        public Collection<Map.Entry<String, String>> headers() {
            return this.headers;
        }

        @Override
        public Map<String, String> queryParameters() {
            return this.params;
        }

        @Override
        public Function<List<String>, Boolean> onWarnings() {
            return this.onWarnings;
        }

        @Override
        public Builder toBuilder() {
            return new BuilderImpl(this);
        }
    }

    public static class BuilderImpl
    implements Builder {
        protected List<Map.Entry<String, String>> headers = Collections.emptyList();
        protected Map<String, String> queryParameters = Collections.emptyMap();
        protected Function<List<String>, Boolean> onWarnings = null;

        public BuilderImpl() {
        }

        public BuilderImpl(TransportOptions src) {
            Map<String, String> srcParams;
            Collection<Map.Entry<String, String>> srcHeaders = src.headers();
            if (srcHeaders != null && !srcHeaders.isEmpty()) {
                this.headers = new ArrayList<Map.Entry<String, String>>(srcHeaders);
            }
            if ((srcParams = src.queryParameters()) != null && !srcParams.isEmpty()) {
                this.queryParameters = new HashMap<String, String>(srcParams);
            }
            this.onWarnings = src.onWarnings();
        }

        @Override
        public Builder addHeader(String name, String value) {
            if (this.headers.isEmpty()) {
                this.headers = new ArrayList<Map.Entry<String, String>>();
            }
            this.headers.add(new AbstractMap.SimpleEntry<String, String>(name, value));
            return this;
        }

        @Override
        public Builder setParameter(String name, String value) {
            if (value == null) {
                if (!this.queryParameters.isEmpty()) {
                    this.queryParameters.remove(name);
                }
            } else {
                if (this.queryParameters.isEmpty()) {
                    this.queryParameters = new HashMap<String, String>();
                }
                this.queryParameters.put(name, value);
            }
            return this;
        }

        @Override
        public Builder onWarnings(Function<List<String>, Boolean> listener) {
            this.onWarnings = listener;
            return this;
        }

        @Override
        public TransportOptions build() {
            return new DefaultImpl(this);
        }
    }

    public static interface Builder
    extends ObjectBuilder<TransportOptions> {
        public Builder addHeader(String var1, String var2);

        public Builder setParameter(String var1, String var2);

        public Builder onWarnings(Function<List<String>, Boolean> var1);
    }
}

