/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.allocation_explain.DiskUsage;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class NodeDiskUsage
implements PlainJsonSerializable {
    private final String nodeName;
    private final DiskUsage leastAvailable;
    private final DiskUsage mostAvailable;
    public static final JsonpDeserializer<NodeDiskUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeDiskUsage::setupNodeDiskUsageDeserializer);

    private NodeDiskUsage(Builder builder) {
        this.nodeName = ApiTypeHelper.requireNonNull(builder.nodeName, this, "nodeName");
        this.leastAvailable = ApiTypeHelper.requireNonNull(builder.leastAvailable, this, "leastAvailable");
        this.mostAvailable = ApiTypeHelper.requireNonNull(builder.mostAvailable, this, "mostAvailable");
    }

    public static NodeDiskUsage of(Function<Builder, ObjectBuilder<NodeDiskUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final DiskUsage leastAvailable() {
        return this.leastAvailable;
    }

    public final DiskUsage mostAvailable() {
        return this.mostAvailable;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_name");
        generator.write(this.nodeName);
        generator.writeKey("least_available");
        this.leastAvailable.serialize(generator, mapper);
        generator.writeKey("most_available");
        this.mostAvailable.serialize(generator, mapper);
    }

    protected static void setupNodeDiskUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name");
        op.add(Builder::leastAvailable, DiskUsage._DESERIALIZER, "least_available");
        op.add(Builder::mostAvailable, DiskUsage._DESERIALIZER, "most_available");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeDiskUsage> {
        private String nodeName;
        private DiskUsage leastAvailable;
        private DiskUsage mostAvailable;

        public final Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        public final Builder leastAvailable(DiskUsage value) {
            this.leastAvailable = value;
            return this;
        }

        public final Builder leastAvailable(Function<DiskUsage.Builder, ObjectBuilder<DiskUsage>> fn) {
            return this.leastAvailable(fn.apply(new DiskUsage.Builder()).build());
        }

        public final Builder mostAvailable(DiskUsage value) {
            this.mostAvailable = value;
            return this;
        }

        public final Builder mostAvailable(Function<DiskUsage.Builder, ObjectBuilder<DiskUsage>> fn) {
            return this.mostAvailable(fn.apply(new DiskUsage.Builder()).build());
        }

        @Override
        public NodeDiskUsage build() {
            this._checkSingleUse();
            return new NodeDiskUsage(this);
        }
    }
}

