/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;
import org.opensearch.client.opensearch._types.mapping.KnnVectorMethod;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KnnVectorProperty
extends DocValuesPropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, KnnVectorProperty> {
    @Nullable
    private final String compressionLevel;
    @Nullable
    private final String dataType;
    private final int dimension;
    @Nullable
    private final KnnVectorMethod method;
    @Nullable
    private final String mode;
    @Nullable
    private final String modelId;
    @Nullable
    private final String spaceType;
    public static final JsonpDeserializer<KnnVectorProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnVectorProperty::setupKnnVectorPropertyDeserializer);

    private KnnVectorProperty(Builder builder) {
        super(builder);
        this.compressionLevel = builder.compressionLevel;
        this.dataType = builder.dataType;
        this.dimension = ApiTypeHelper.requireNonNull(builder.dimension, this, "dimension");
        this.method = builder.method;
        this.mode = builder.mode;
        this.modelId = builder.modelId;
        this.spaceType = builder.spaceType;
    }

    public static KnnVectorProperty of(Function<Builder, ObjectBuilder<KnnVectorProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.KnnVector;
    }

    @Nullable
    public final String compressionLevel() {
        return this.compressionLevel;
    }

    @Nullable
    public final String dataType() {
        return this.dataType;
    }

    public final int dimension() {
        return this.dimension;
    }

    @Nullable
    public final KnnVectorMethod method() {
        return this.method;
    }

    @Nullable
    public final String mode() {
        return this.mode;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String spaceType() {
        return this.spaceType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "knn_vector");
        super.serializeInternal(generator, mapper);
        if (this.compressionLevel != null) {
            generator.writeKey("compression_level");
            generator.write(this.compressionLevel);
        }
        if (this.dataType != null) {
            generator.writeKey("data_type");
            generator.write(this.dataType);
        }
        generator.writeKey("dimension");
        generator.write(this.dimension);
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            generator.write(this.mode);
        }
        if (this.modelId != null) {
            generator.writeKey("model_id");
            generator.write(this.modelId);
        }
        if (this.spaceType != null) {
            generator.writeKey("space_type");
            generator.write(this.spaceType);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKnnVectorPropertyDeserializer(ObjectDeserializer<Builder> op) {
        KnnVectorProperty.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::compressionLevel, JsonpDeserializer.stringDeserializer(), "compression_level");
        op.add(Builder::dataType, JsonpDeserializer.stringDeserializer(), "data_type");
        op.add(Builder::dimension, JsonpDeserializer.integerDeserializer(), "dimension");
        op.add(Builder::method, KnnVectorMethod._DESERIALIZER, "method");
        op.add(Builder::mode, JsonpDeserializer.stringDeserializer(), "mode");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::spaceType, JsonpDeserializer.stringDeserializer(), "space_type");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.compressionLevel);
        result = 31 * result + Objects.hashCode(this.dataType);
        result = 31 * result + Integer.hashCode(this.dimension);
        result = 31 * result + Objects.hashCode(this.method);
        result = 31 * result + Objects.hashCode(this.mode);
        result = 31 * result + Objects.hashCode(this.modelId);
        result = 31 * result + Objects.hashCode(this.spaceType);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnnVectorProperty other = (KnnVectorProperty)o;
        return Objects.equals(this.compressionLevel, other.compressionLevel) && Objects.equals(this.dataType, other.dataType) && this.dimension == other.dimension && Objects.equals(this.method, other.method) && Objects.equals(this.mode, other.mode) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.spaceType, other.spaceType);
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KnnVectorProperty> {
        @Nullable
        private String compressionLevel;
        @Nullable
        private String dataType;
        private Integer dimension;
        @Nullable
        private KnnVectorMethod method;
        @Nullable
        private String mode;
        @Nullable
        private String modelId;
        @Nullable
        private String spaceType;

        public Builder() {
        }

        private Builder(KnnVectorProperty o) {
            super(o);
            this.compressionLevel = o.compressionLevel;
            this.dataType = o.dataType;
            this.dimension = o.dimension;
            this.method = o.method;
            this.mode = o.mode;
            this.modelId = o.modelId;
            this.spaceType = o.spaceType;
        }

        private Builder(Builder o) {
            super(o);
            this.compressionLevel = o.compressionLevel;
            this.dataType = o.dataType;
            this.dimension = o.dimension;
            this.method = o.method;
            this.mode = o.mode;
            this.modelId = o.modelId;
            this.spaceType = o.spaceType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder compressionLevel(@Nullable String value) {
            this.compressionLevel = value;
            return this;
        }

        @Nonnull
        public final Builder dataType(@Nullable String value) {
            this.dataType = value;
            return this;
        }

        @Nonnull
        public final Builder dimension(int value) {
            this.dimension = value;
            return this;
        }

        @Nonnull
        public final Builder method(@Nullable KnnVectorMethod value) {
            this.method = value;
            return this;
        }

        @Nonnull
        public final Builder method(Function<KnnVectorMethod.Builder, ObjectBuilder<KnnVectorMethod>> fn) {
            return this.method(fn.apply(new KnnVectorMethod.Builder()).build());
        }

        @Nonnull
        public final Builder mode(@Nullable String value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder spaceType(@Nullable String value) {
            this.spaceType = value;
            return this;
        }

        @Override
        @Nonnull
        public KnnVectorProperty build() {
            this._checkSingleUse();
            return new KnnVectorProperty(this);
        }
    }
}

