/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.BindRequestAuthenticationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationRequestAccessLogMessage;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class BindRequestAccessLogMessage
extends OperationRequestAccessLogMessage {
    private static final long serialVersionUID = 8603928027823970L;
    @Nullable
    private final BindRequestAuthenticationType authenticationType;
    @Nullable
    private final String dn = this.getNamedValue("dn");
    @Nullable
    private final String protocolVersion;
    @Nullable
    private final String saslMechanismName = this.getNamedValue("saslMechanism");

    public BindRequestAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public BindRequestAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        this.protocolVersion = this.getNamedValue("version");
        BindRequestAuthenticationType authType = null;
        try {
            authType = BindRequestAuthenticationType.valueOf(this.getNamedValue("authType"));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.authenticationType = authType;
    }

    @Nullable
    public final BindRequestAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Nullable
    public final String getDN() {
        return this.dn;
    }

    @Nullable
    public final String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Nullable
    public final String getSASLMechanismName() {
        return this.saslMechanismName;
    }

    @Override
    @NotNull
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.BIND;
    }
}

