/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import jakarta.mail.MessagingException;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.ReprocessingService;

public class ReprocessingOneMailTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"reprocessing-one");
    private final ReprocessingService reprocessingService;
    private final MailRepositoryPath repositoryPath;
    private final ReprocessingService.Configuration configuration;
    private final MailKey mailKey;
    private final AdditionalInformation additionalInformation;

    public ReprocessingOneMailTask(ReprocessingService reprocessingService, MailRepositoryPath repositoryPath, ReprocessingService.Configuration configuration, MailKey mailKey, Clock clock) {
        this.reprocessingService = reprocessingService;
        this.repositoryPath = repositoryPath;
        this.configuration = configuration;
        this.mailKey = mailKey;
        this.additionalInformation = new AdditionalInformation(repositoryPath, configuration, mailKey, clock.instant());
    }

    public Task.Result run() {
        try {
            this.reprocessingService.reprocess(this.repositoryPath, this.mailKey, this.configuration);
            return Task.Result.COMPLETED;
        }
        catch (MessagingException | MailRepositoryStore.MailRepositoryStoreException e) {
            LOGGER.error("Encountered error while reprocessing repository", e);
            return Task.Result.PARTIAL;
        }
    }

    public TaskType type() {
        return TYPE;
    }

    MailRepositoryPath getRepositoryPath() {
        return this.repositoryPath;
    }

    MailKey getMailKey() {
        return this.mailKey;
    }

    public ReprocessingService.Configuration getConfiguration() {
        return this.configuration;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailRepositoryPath repositoryPath;
        private final ReprocessingService.Configuration configuration;
        private final MailKey mailKey;
        private final Instant timestamp;

        public AdditionalInformation(MailRepositoryPath repositoryPath, ReprocessingService.Configuration configuration, MailKey mailKey, Instant timestamp) {
            this.repositoryPath = repositoryPath;
            this.configuration = configuration;
            this.mailKey = mailKey;
            this.timestamp = timestamp;
        }

        public String getMailKey() {
            return this.mailKey.asString();
        }

        public ReprocessingService.Configuration getConfiguration() {
            return this.configuration;
        }

        public String getRepositoryPath() {
            return this.repositoryPath.asString();
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class InvalidMailRepositoryPathDeserializationException
    extends RuntimeException {
        public InvalidMailRepositoryPathDeserializationException(String mailRepositoryPath) {
            super("Unable to deserialize: '" + mailRepositoryPath + "' can not be url decoded");
        }
    }

    public static class UrlEncodingFailureSerializationException
    extends RuntimeException {
        public UrlEncodingFailureSerializationException(MailRepositoryPath mailRepositoryPath) {
            super("Unable to serialize: '" + mailRepositoryPath.asString() + "' can not be url encoded");
        }
    }
}

