/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class FloatListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<float[]> {
    public FloatListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.FLOAT), GenericType.of(float[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return float[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        return value instanceof float[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 4;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull float[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        output.putFloat(array[index]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input, @NonNull float[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        array[index] = input.getFloat();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull float[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(@NonNull String input, @NonNull float[] array, int index) {
        array[index] = Float.parseFloat(input);
    }

    @Override
    @NonNull
    protected float[] newInstance(int size) {
        return new float[size];
    }
}

