/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphExecutionInfo;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.internal.core.graph.GraphExecutionInfoConverter;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphResultIterator;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DefaultAsyncGraphResultSet
implements AsyncGraphResultSet {
    private final ExecutionInfo executionInfo;
    private final CountingIterator<GraphNode> iterator;
    private final Iterable<GraphNode> currentPage;

    public DefaultAsyncGraphResultSet(ExecutionInfo executionInfo, Queue<GraphNode> data, GraphProtocol graphProtocol) {
        this.executionInfo = executionInfo;
        this.iterator = new GraphResultIterator(data, graphProtocol);
        this.currentPage = () -> this.iterator;
    }

    @Override
    @NonNull
    public ExecutionInfo getRequestExecutionInfo() {
        return this.executionInfo;
    }

    @Override
    @Deprecated
    @NonNull
    public GraphExecutionInfo getExecutionInfo() {
        return GraphExecutionInfoConverter.convert(this.executionInfo);
    }

    @Override
    public int remaining() {
        return this.iterator.remaining();
    }

    @Override
    @NonNull
    public Iterable<GraphNode> currentPage() {
        return this.currentPage;
    }

    @Override
    public boolean hasMorePages() {
        return false;
    }

    @Override
    @NonNull
    public CompletionStage<AsyncGraphResultSet> fetchNextPage() throws IllegalStateException {
        throw new IllegalStateException("No next page. Use #hasMorePages before calling this method to avoid this error.");
    }

    @Override
    public void cancel() {
    }
}

