/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SearchEntryAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSearchRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TextFormattedSearchEntryAccessLogMessage
extends TextFormattedSearchRequestAccessLogMessage
implements SearchEntryAccessLogMessage {
    private static final long serialVersionUID = 7106446575112520912L;
    @NotNull
    private final Set<String> attributesReturned;
    @NotNull
    private final Set<String> responseControlOIDs;
    @Nullable
    private final String dn = this.getString(TextFormattedAccessLogFields.SEARCH_RESULT_ENTRY_DN);

    public TextFormattedSearchEntryAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedSearchEntryAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.attributesReturned = this.getCommaDelimitedStringSet(TextFormattedAccessLogFields.SEARCH_RESULT_ENTRY_ATTRIBUTES);
        this.responseControlOIDs = this.getCommaDelimitedStringSet(TextFormattedAccessLogFields.RESPONSE_CONTROL_OIDS);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY;
    }

    @Override
    @Nullable
    public String getDN() {
        return this.dn;
    }

    @Override
    @NotNull
    public Set<String> getAttributesReturned() {
        return this.attributesReturned;
    }

    @Override
    @NotNull
    public Set<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }
}

