/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class POP3BeforeSMTPHelper {
    public static final Map<String, Instant> IP_MAP = Collections.synchronizedMap(new HashMap());
    public static final Duration EXPIRE_TIME = Duration.ofHours(60L);

    public static boolean isAuthorized(String ipAddress) {
        return IP_MAP.containsKey(ipAddress);
    }

    public static void addIPAddress(String ipAddress) {
        IP_MAP.put(ipAddress, Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExpiredIP(Duration clearTime) {
        Map<String, Instant> map = IP_MAP;
        synchronized (map) {
            Iterator<String> storedIP = IP_MAP.keySet().iterator();
            while (storedIP.hasNext()) {
                String key = storedIP.next();
                Instant storedTime = IP_MAP.get(key);
                if (!Instant.now().minus(clearTime).isAfter(storedTime)) continue;
                storedIP.remove();
                IP_MAP.remove(key);
            }
        }
    }
}

