/*
 * Decompiled with CFR 0.152.
 */
package com.beetstra.jutf7;

import java.util.Arrays;

class Base64Util {
    private static final int ALPHABET_LENGTH = 64;
    private final char[] alphabet;
    private final int[] inverseAlphabet;

    Base64Util(String alphabet) {
        this.alphabet = alphabet.toCharArray();
        if (alphabet.length() != 64) {
            throw new IllegalArgumentException("alphabet has incorrect length (should be 64, not " + alphabet.length() + ")");
        }
        this.inverseAlphabet = new int[128];
        Arrays.fill(this.inverseAlphabet, -1);
        int i = 0;
        while (i < this.alphabet.length) {
            char ch = this.alphabet[i];
            if (ch >= '\u0080') {
                throw new IllegalArgumentException("invalid character in alphabet: " + ch);
            }
            this.inverseAlphabet[ch] = i++;
        }
    }

    int getSextet(byte ch) {
        if (ch >= 128) {
            return -1;
        }
        return this.inverseAlphabet[ch];
    }

    boolean contains(char ch) {
        if (ch >= '\u0080') {
            return false;
        }
        return this.inverseAlphabet[ch] >= 0;
    }

    byte getChar(int sextet) {
        return (byte)this.alphabet[sextet];
    }
}

