/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.update;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class CollectionElementAssignment
implements Assignment {
    private final CqlIdentifier columnId;
    private final Operator operator;
    private final Term key;
    private final Term value;
    private final char opening;
    private final char closing;

    protected CollectionElementAssignment(@NonNull CqlIdentifier columnId, @NonNull Operator operator, @Nullable Term key, @NonNull Term value, char opening, char closing) {
        Preconditions.checkNotNull((Object)columnId);
        Preconditions.checkNotNull((Object)value);
        this.columnId = columnId;
        this.operator = operator;
        this.key = key;
        this.value = value;
        this.opening = opening;
        this.closing = closing;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append(String.format(this.operator.pattern, this.columnId.asCql(true), this.buildRightOperand()));
    }

    private String buildRightOperand() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.opening);
        if (this.key != null) {
            this.key.appendTo(builder);
            builder.append(':');
        }
        this.value.appendTo(builder);
        return builder.append(this.closing).toString();
    }

    @Override
    public boolean isIdempotent() {
        return (this.key == null || this.key.isIdempotent()) && this.value.isIdempotent();
    }

    @NonNull
    public CqlIdentifier getColumnId() {
        return this.columnId;
    }

    @Nullable
    public Term getKey() {
        return this.key;
    }

    @NonNull
    public Term getValue() {
        return this.value;
    }

    public char getOpening() {
        return this.opening;
    }

    public char getClosing() {
        return this.closing;
    }

    public static enum Operator {
        APPEND("%1$s=%1$s+%2$s"),
        PREPEND("%1$s=%2$s+%1$s"),
        REMOVE("%1$s=%1$s-%2$s");

        public final String pattern;

        private Operator(String pattern) {
            this.pattern = pattern;
        }
    }
}

