/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeAllTask
implements Task {
    static final TaskType TASK_TYPE = TaskType.of((String)"SubscribeAllTask");
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribeAllTask.class);
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final Username username;
    private final AtomicLong subscribedCount;
    private final AtomicLong unsubscribedCount;

    public SubscribeAllTask(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, Username username) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.username = username;
        this.subscribedCount = new AtomicLong(0L);
        this.unsubscribedCount = new AtomicLong(0L);
    }

    public Task.Result run() {
        MailboxSession session = this.mailboxManager.createSystemSession(this.username);
        try {
            Collection subscriptions = this.subscriptionManager.subscriptions(session);
            List names = (List)this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).build(), session).map(MailboxMetaData::getPath).collectList().block();
            subscriptions.stream().filter(subscription -> !names.contains(subscription)).forEach((Consumer<MailboxPath>)Throwing.consumer(subscription -> {
                this.subscriptionManager.unsubscribe(session, subscription);
                this.unsubscribedCount.incrementAndGet();
            }));
            names.stream().filter(name -> !subscriptions.contains(name)).forEach((Consumer<MailboxPath>)Throwing.consumer(name -> {
                this.subscriptionManager.subscribe(session, name);
                this.subscribedCount.incrementAndGet();
            }));
        }
        catch (SubscriptionException e) {
            LOGGER.error("Couldnot retrieve subscriptions for {}", (Object)this.username, (Object)e);
            return Task.Result.PARTIAL;
        }
        return Task.Result.COMPLETED;
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.username, this.subscribedCount.get(), this.unsubscribedCount.get(), Clock.systemUTC().instant()));
    }

    public Username getUsername() {
        return this.username;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Username username;
        private final long subscribedCount;
        private final long unsubscribedCount;
        private final Instant timestamp;

        public AdditionalInformation(Username username, long subscribedCount, long unsubscribedCount, Instant timestamp) {
            this.username = username;
            this.subscribedCount = subscribedCount;
            this.unsubscribedCount = unsubscribedCount;
            this.timestamp = timestamp;
        }

        public Username getUsername() {
            return this.username;
        }

        public long getSubscribedCount() {
            return this.subscribedCount;
        }

        public long getUnsubscribedCount() {
            return this.unsubscribedCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

