/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FileExtension {
    static final String ZIP_EXTENSION_STRING = "zip";
    public static final FileExtension ZIP = new FileExtension("zip");
    private static final String EXTENSION_SEPARATOR = ".";
    private final String extension;

    public static FileExtension of(String extension) {
        return new FileExtension(extension);
    }

    @VisibleForTesting
    FileExtension(String extension) {
        Preconditions.checkNotNull((Object)extension, (Object)"'extension' can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)extension), (Object)"'extension' can not be blank");
        this.extension = extension;
    }

    public String appendExtension(String filePath) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)filePath), (Object)"filePath cannot be null or blank");
        return filePath + this.asFileSuffix();
    }

    public String asFileSuffix() {
        return EXTENSION_SEPARATOR + this.extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public final boolean equals(Object o) {
        if (o instanceof FileExtension) {
            FileExtension that = (FileExtension)o;
            return Objects.equals(this.extension, that.extension);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.extension);
    }
}

