/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class CommandWatchTopicListSuccess {
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 1;
    private static final int _REQUEST_ID_TAG = 8;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _REQUEST_ID_MASK = 1;
    private long watcherId;
    private static final int _WATCHER_ID_FIELD_NUMBER = 2;
    private static final int _WATCHER_ID_TAG = 16;
    private static final int _WATCHER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _WATCHER_ID_MASK = 2;
    private List<LightProtoCodec.StringHolder> topics = null;
    private int _topicsCount = 0;
    private static final int _TOPIC_FIELD_NUMBER = 3;
    private static final int _TOPIC_TAG = 26;
    private static final int _TOPIC_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private String topicsHash;
    private int _topicsHashBufferIdx = -1;
    private int _topicsHashBufferLen = -1;
    private static final int _TOPICS_HASH_FIELD_NUMBER = 4;
    private static final int _TOPICS_HASH_TAG = 34;
    private static final int _TOPICS_HASH_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private static final int _TOPICS_HASH_MASK = 8;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 11;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasRequestId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandWatchTopicListSuccess setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandWatchTopicListSuccess clearRequestId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasWatcherId() {
        return (this._bitField0 & 2) != 0;
    }

    public long getWatcherId() {
        if (!this.hasWatcherId()) {
            throw new IllegalStateException("Field 'watcher_id' is not set");
        }
        return this.watcherId;
    }

    public CommandWatchTopicListSuccess setWatcherId(long watcherId) {
        this.watcherId = watcherId;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandWatchTopicListSuccess clearWatcherId() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public int getTopicsCount() {
        return this._topicsCount;
    }

    public String getTopicAt(int idx) {
        if (idx < 0 || idx >= this._topicsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._topicsCount + ") for field 'topic'");
        }
        LightProtoCodec.StringHolder _sh = this.topics.get(idx);
        if (_sh.s == null) {
            _sh.s = LightProtoCodec.readString(this._parsedBuffer, _sh.idx, _sh.len);
        }
        return _sh.s;
    }

    public List<String> getTopicsList() {
        if (this._topicsCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> _l = new ArrayList<String>();
        for (int i = 0; i < this._topicsCount; ++i) {
            _l.add(this.getTopicAt(i));
        }
        return _l;
    }

    public void addTopic(String topic) {
        if (this.topics == null) {
            this.topics = new ArrayList<LightProtoCodec.StringHolder>();
        }
        LightProtoCodec.StringHolder _sh = this._newTopicStringHolder();
        this._cachedSize = -1;
        _sh.s = topic;
        _sh.idx = -1;
        _sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
    }

    public CommandWatchTopicListSuccess addAllTopics(Iterable<String> topics) {
        for (String _s : topics) {
            this.addTopic(_s);
        }
        return this;
    }

    private LightProtoCodec.StringHolder _newTopicStringHolder() {
        LightProtoCodec.StringHolder _sh;
        if (this.topics == null) {
            this.topics = new ArrayList<LightProtoCodec.StringHolder>();
        }
        if (this.topics.size() == this._topicsCount) {
            _sh = new LightProtoCodec.StringHolder();
            this.topics.add(_sh);
        } else {
            _sh = this.topics.get(this._topicsCount);
        }
        ++this._topicsCount;
        return _sh;
    }

    public CommandWatchTopicListSuccess clearTopic() {
        for (int i = 0; i < this._topicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.topics.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._topicsCount = 0;
        return this;
    }

    public boolean hasTopicsHash() {
        return (this._bitField0 & 8) != 0;
    }

    public String getTopicsHash() {
        if (!this.hasTopicsHash()) {
            throw new IllegalStateException("Field 'topics_hash' is not set");
        }
        if (this.topicsHash == null) {
            this.topicsHash = LightProtoCodec.readString(this._parsedBuffer, this._topicsHashBufferIdx, this._topicsHashBufferLen);
        }
        return this.topicsHash;
    }

    public CommandWatchTopicListSuccess setTopicsHash(String topicsHash) {
        this.topicsHash = topicsHash;
        this._bitField0 |= 8;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = LightProtoCodec.computeStringUTF8Size(topicsHash);
        this._cachedSize = -1;
        return this;
    }

    public CommandWatchTopicListSuccess clearTopicsHash() {
        this._bitField0 &= 0xFFFFFFF7;
        this.topicsHash = null;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = -1;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.requestId);
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.watcherId);
        for (int i = 0; i < this._topicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.topics.get(i);
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, _sh.len);
            if (_sh.idx == -1) {
                LightProtoCodec.writeString(_b, _sh.s, _sh.len);
                continue;
            }
            this._parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
        }
        LightProtoCodec.writeVarInt(_b, 34);
        LightProtoCodec.writeVarInt(_b, this._topicsHashBufferLen);
        if (this._topicsHashBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.topicsHash, this._topicsHashBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._topicsHashBufferIdx, _b, this._topicsHashBufferLen);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _REQUEST_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        _size += _WATCHER_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.watcherId);
        for (int i = 0; i < this._topicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.topics.get(i);
            _size += _TOPIC_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
        }
        _size += _TOPICS_HASH_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._topicsHashBufferLen);
        this._cachedSize = _size += this._topicsHashBufferLen;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block6: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.watcherId = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 26: {
                    LightProtoCodec.StringHolder _topicSh = this._newTopicStringHolder();
                    _topicSh.len = LightProtoCodec.readVarInt(_buffer);
                    _topicSh.idx = _buffer.readerIndex();
                    _buffer.skipBytes(_topicSh.len);
                    continue block6;
                }
                case 34: {
                    this._bitField0 |= 8;
                    this._topicsHashBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._topicsHashBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._topicsHashBufferLen);
                    continue block6;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 0xB) != 11) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandWatchTopicListSuccess clear() {
        for (int i = 0; i < this._topicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.topics.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._topicsCount = 0;
        this.topicsHash = null;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = -1;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandWatchTopicListSuccess copyFrom(CommandWatchTopicListSuccess _other) {
        this._cachedSize = -1;
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        if (_other.hasWatcherId()) {
            this.setWatcherId(_other.watcherId);
        }
        for (int i = 0; i < _other.getTopicsCount(); ++i) {
            this.addTopic(_other.getTopicAt(i));
        }
        if (_other.hasTopicsHash()) {
            this.setTopicsHash(_other.getTopicsHash());
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

