/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;
import org.apache.mailbox.tools.indexer.UserReindexingTask;

public class UserReindexingTaskDTO
implements TaskDTO {
    private final String type;
    private final String username;
    private final Optional<RunningOptionsDTO> runningOptions;

    private static UserReindexingTaskDTO of(UserReindexingTask task, String type) {
        return new UserReindexingTaskDTO(type, task.getUsername().asString(), Optional.of(RunningOptionsDTO.toDTO(task.getRunningOptions())));
    }

    public static TaskDTOModule<UserReindexingTask, UserReindexingTaskDTO> module(UserReindexingTask.Factory factory) {
        return (TaskDTOModule)DTOModule.forDomainObject(UserReindexingTask.class).convertToDTO(UserReindexingTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter(UserReindexingTaskDTO::of).typeName(UserReindexingTask.USER_RE_INDEXING.asString()).withFactory(TaskDTOModule::new);
    }

    private UserReindexingTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="username") String username, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
        this.type = type;
        this.username = username;
        this.runningOptions = runningOptions;
    }

    public String getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }
}

