/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.stream.Field;

public abstract class AbstractHeader
implements Header {
    private final List<Field> fields = new LinkedList<Field>();
    private final Map<String, List<Field>> fieldMap = new HashMap<String, List<Field>>();

    public AbstractHeader() {
    }

    public AbstractHeader(Header other) {
        for (Field otherField : other.getFields()) {
            this.addField(otherField);
        }
    }

    @Override
    public void addField(Field field2) {
        String lowerCaseFieldName = field2.getNameLowerCase();
        List<Field> values = this.fieldMap.get(lowerCaseFieldName);
        if (values == null) {
            values = new LinkedList<Field>();
            this.fieldMap.put(lowerCaseFieldName, values);
        }
        values.add(field2);
        this.fields.add(field2);
    }

    @Override
    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public Map<String, List<Field>> getFieldsAsMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }

    @Override
    public Field getField(String name) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        if (l != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    @Override
    public <F extends Field> F getField(String name, Class<F> clazz) {
        List<Field> l = this.fieldMap.get(name.toLowerCase(Locale.US));
        if (l == null) {
            return null;
        }
        for (int i = 0; i < l.size(); ++i) {
            Field field2 = l.get(i);
            if (!clazz.isInstance(field2)) continue;
            return (F)((Field)clazz.cast(field2));
        }
        return null;
    }

    @Override
    public List<Field> getFields(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        List<Field> results = l == null || l.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(l);
        return results;
    }

    @Override
    public <F extends Field> List<F> getFields(String name, Class<F> clazz) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> results = new ArrayList<Field>();
        for (int i = 0; i < l.size(); ++i) {
            Field field2 = l.get(i);
            if (!clazz.isInstance(field2)) continue;
            results.add((Field)clazz.cast(field2));
        }
        return results;
    }

    @Override
    public Iterator<Field> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    @Override
    public int removeFields(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        List<Field> removed = this.fieldMap.remove(lowerCaseName);
        if (removed == null || removed.isEmpty()) {
            return 0;
        }
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field field2 = iterator.next();
            if (!field2.getName().equalsIgnoreCase(name)) continue;
            iterator.remove();
        }
        return removed.size();
    }

    @Override
    public void setField(Field field2) {
        String lowerCaseName = field2.getNameLowerCase();
        List<Field> l = this.fieldMap.get(lowerCaseName);
        if (l == null || l.isEmpty()) {
            this.addField(field2);
            return;
        }
        l.clear();
        l.add(field2);
        int firstOccurrence = -1;
        int index = 0;
        Iterator<Field> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field f = iterator.next();
            if (f.getName().equalsIgnoreCase(field2.getName())) {
                iterator.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index;
                }
            }
            ++index;
        }
        this.fields.add(firstOccurrence, field2);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(128);
        for (Field field2 : this.fields) {
            str.append(field2.toString());
            str.append("\r\n");
        }
        return str.toString();
    }
}

