/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.reporting;

import com.google.common.annotations.VisibleForTesting;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import org.apache.commons.lang3.function.TriConsumer;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.polaris.service.reporting.PolarisMetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="default")
public class DefaultMetricsReporter
implements PolarisMetricsReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMetricsReporter.class);
    private final TriConsumer<String, TableIdentifier, MetricsReport> reportConsumer;

    public DefaultMetricsReporter() {
        this((TriConsumer<String, TableIdentifier, MetricsReport>)((TriConsumer)(catalogName, table, metricsReport) -> LOGGER.info("{}.{}: {}", new Object[]{catalogName, table, metricsReport})));
    }

    @VisibleForTesting
    DefaultMetricsReporter(TriConsumer<String, TableIdentifier, MetricsReport> reportConsumer) {
        this.reportConsumer = reportConsumer;
    }

    @Override
    public void reportMetric(String catalogName, TableIdentifier table, MetricsReport metricsReport) {
        this.reportConsumer.accept((Object)catalogName, (Object)table, (Object)metricsReport);
    }
}

