/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.common;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;

public class CatalogUtils {
    public static PolarisResolvedPathWrapper findResolvedStorageEntity(PolarisResolutionManifestCatalogView resolvedEntityView, TableIdentifier tableIdentifier) {
        PolarisResolvedPathWrapper resolvedTableEntities = resolvedEntityView.getResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_TABLE);
        if (resolvedTableEntities != null) {
            return resolvedTableEntities;
        }
        return resolvedEntityView.getResolvedPath((Object)tableIdentifier.namespace());
    }

    public static void validateLocationsForTableLike(RealmConfig realmConfig, TableIdentifier identifier, Set<String> locations, PolarisResolvedPathWrapper resolvedStorageEntity) {
        PolarisStorageConfigurationInfo.forEntityPath((RealmConfig)realmConfig, (List)resolvedStorageEntity.getRawFullPath()).ifPresentOrElse(restrictions -> restrictions.validate(realmConfig, identifier, locations), () -> {
            List invalidLocations;
            List allowedStorageTypes = (List)realmConfig.getConfig("SUPPORTED_CATALOG_STORAGE_TYPES");
            if (allowedStorageTypes != null && !allowedStorageTypes.contains(StorageConfigInfo.StorageTypeEnum.FILE.name()) && !(invalidLocations = locations.stream().filter(location -> location.startsWith("file:") || location.startsWith("http")).collect(Collectors.toList())).isEmpty()) {
                throw new ForbiddenException("Invalid locations '%s' for identifier '%s': File locations are not allowed", new Object[]{invalidLocations, identifier});
            }
        });
    }
}

