/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.propertyservice;

import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SaxHandler
extends DefaultHandler {
    private final Properties properties = new Properties();
    private boolean isEntry = false;
    private String currentKey = null;
    private StringBuffer currentBuffer = null;

    public Properties getProperties() {
        Properties propertiesCopy = new Properties();
        propertiesCopy.putAll((Map<?, ?>)this.properties);
        return propertiesCopy;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.toLowerCase().equals("entry") && attributes.getLength() > 0) {
            this.currentKey = this.getAttributeValue("key", attributes);
            if (this.currentKey != null) {
                this.isEntry = true;
                this.currentBuffer = new StringBuffer();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.toLowerCase().equals("entry") && this.isEntry) {
            this.properties.put(this.currentKey, this.currentBuffer.toString().trim());
            this.currentKey = null;
            this.currentBuffer = null;
            this.isEntry = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isEntry) {
            this.currentBuffer.append(ch, start, length);
        }
    }

    private String getAttributeValue(String name, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).toLowerCase().equals(name.toLowerCase())) continue;
            return attributes.getValue(i);
        }
        return null;
    }
}

