/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FormattingCLIUtils {
    private String title;
    private TableRowType lastTableRowType;
    private StringBuilder join;
    private List<TableRow> tableRows;
    private Map<Integer, Integer> maxColMap;

    public FormattingCLIUtils(String title) {
        this.init();
        this.title = title;
    }

    private void init() {
        this.join = new StringBuilder();
        this.tableRows = new ArrayList<TableRow>();
        this.maxColMap = new HashMap<Integer, Integer>();
    }

    public FormattingCLIUtils addHeaders(List<?> headers) {
        return this.appendRows(TableRowType.HEADER, headers.toArray());
    }

    public FormattingCLIUtils addLine(Object ... objects) {
        return this.appendRows(TableRowType.LINE, objects);
    }

    private FormattingCLIUtils appendRows(TableRowType tableRowType, Object ... objects) {
        if (objects != null && objects.length > 0) {
            int len = objects.length;
            if (this.maxColMap.size() > len) {
                throw new IllegalArgumentException("The number of columns that inserted a row of data into the table is different from the number of previous columns, check!");
            }
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = 0; i < len; ++i) {
                Object o = objects[i];
                String value = o == null ? "null" : o.toString();
                lines.add(value);
                Integer maxColSize = this.maxColMap.get(i);
                if (maxColSize == null) {
                    this.maxColMap.put(i, value.length());
                    continue;
                }
                if (value.length() <= maxColSize) continue;
                this.maxColMap.put(i, value.length());
            }
            this.tableRows.add(new TableRow(tableRowType, lines));
        }
        return this;
    }

    private void buildTitle() {
        if (this.title != null) {
            int maxTitleSize = 0;
            for (Integer maxColSize : this.maxColMap.values()) {
                maxTitleSize += maxColSize.intValue();
            }
            if (this.title.length() > (maxTitleSize += 3 * (this.maxColMap.size() - 1))) {
                this.title = this.title.substring(0, maxTitleSize);
            }
            this.join.append("+");
            for (int i = 0; i < maxTitleSize + 2; ++i) {
                this.join.append("-");
            }
            this.join.append("+\n").append("|").append(StrUtils.center(this.title, maxTitleSize + 2, ' ')).append("|\n");
            this.lastTableRowType = TableRowType.TITLE;
        }
    }

    private void buildTable() {
        this.buildTitle();
        int len = this.tableRows.size();
        block4: for (int i = 0; i < len; ++i) {
            List data = this.tableRows.get(i).data;
            switch (this.tableRows.get(i).tableRowType) {
                case HEADER: {
                    if (this.lastTableRowType != TableRowType.HEADER) {
                        this.buildRowBorder(data);
                    }
                    this.buildRowLine(data);
                    this.buildRowBorder(data);
                    continue block4;
                }
                case LINE: {
                    this.buildRowLine(data);
                    if (i != len - 1) continue block4;
                    this.buildRowBorder(data);
                    continue block4;
                }
            }
        }
    }

    private void buildRowBorder(List<String> data) {
        this.join.append("+");
        int len = data.size();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < this.maxColMap.get(i) + 2; ++j) {
                this.join.append("-");
            }
            this.join.append("+");
        }
        this.join.append("\n");
    }

    private void buildRowLine(List<String> data) {
        this.join.append("|");
        int len = data.size();
        for (int i = 0; i < len; ++i) {
            this.join.append(StrUtils.center(data.get(i), this.maxColMap.get(i) + 2, ' ')).append("|");
        }
        this.join.append("\n");
    }

    public String render() {
        this.buildTable();
        return this.join.toString();
    }

    private static final class StrUtils {
        private StrUtils() {
        }

        private static String center(String str, int size, char padChar) {
            int strLen;
            int pads;
            if (str != null && size > 0 && (pads = size - (strLen = str.length())) > 0) {
                str = StrUtils.leftPad(str, strLen + pads / 2, padChar);
                str = StrUtils.rightPad(str, size, padChar);
            }
            return str;
        }

        private static String leftPad(String str, int size, char padChar) {
            int pads = size - str.length();
            return pads <= 0 ? str : StrUtils.repeat(padChar, pads).concat(str);
        }

        private static String rightPad(String str, int size, char padChar) {
            int pads = size - str.length();
            return pads <= 0 ? str : str.concat(StrUtils.repeat(padChar, pads));
        }

        private static String repeat(char ch, int repeat) {
            char[] buf = new char[repeat];
            for (int i = repeat - 1; i >= 0; --i) {
                buf[i] = ch;
            }
            return new String(buf);
        }
    }

    private static enum TableRowType {
        TITLE,
        HEADER,
        LINE;

    }

    private static class TableRow {
        private TableRowType tableRowType;
        private List<String> data;

        TableRow(TableRowType tableRowType, List<String> data) {
            this.tableRowType = tableRowType;
            this.data = data;
        }
    }
}

