/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiOnSubscribeCall;
import io.smallrye.mutiny.operators.multi.MultiOnSubscribeInvokeOp;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class MultiOnSubscribe<T> {
    private final Multi<T> upstream;

    public MultiOnSubscribe(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Multi<T> invoke(Consumer<? super Flow.Subscription> callback) {
        Consumer<? super Flow.Subscription> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return Infrastructure.onMultiCreation(new MultiOnSubscribeInvokeOp<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Multi<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super Flow.Subscription ignored) -> actual.run());
    }

    @CheckReturnValue
    public Multi<T> call(Function<? super Flow.Subscription, Uni<?>> action) {
        Function<? super Flow.Subscription, Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return Infrastructure.onMultiCreation(new MultiOnSubscribeCall<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Multi<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.call((? super Flow.Subscription ignored) -> (Uni)actual.get());
    }
}

