/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.loader.reader.jdbc.Fetcher;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.jdbc.JDBCSource;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class JDBCFetcher
extends Fetcher {
    private static final Logger LOG = Log.logger(JDBCFetcher.class);
    private Statement stmt = null;
    private ResultSet result = null;
    long offSet = 0L;
    boolean start = false;
    boolean done = false;
    String[] columns = null;

    public JDBCFetcher(JDBCSource source) throws SQLException {
        super(source);
    }

    @Override
    public String[] readHeader() {
        return null;
    }

    @Override
    public void readPrimaryKey() {
    }

    @Override
    public void close() {
        try {
            if (this.result != null && !this.result.isClosed()) {
                this.result.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close 'ResultSet'", (Throwable)e);
        }
        try {
            if (this.stmt != null && !this.stmt.isClosed()) {
                this.stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close 'Statement'", (Throwable)e);
        }
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close 'Connection'", (Throwable)e);
        }
    }

    @Override
    public List<Line> nextBatch() throws SQLException {
        if (!this.start) {
            this.stmt = this.conn.createStatement(1003, 1007);
            this.result = this.stmt.executeQuery(this.buildSql());
            this.result.setFetchSize(this.source.batchSize());
            ResultSetMetaData metaData = this.result.getMetaData();
            this.columns = new String[metaData.getColumnCount()];
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String fieldName = metaData.getColumnName(i);
                this.columns[i - 1] = fieldName.replaceFirst(this.source.table() + ".", "");
            }
            this.source.header(this.columns);
            this.start = true;
        }
        if (this.done) {
            LOG.warn("no other data");
            return null;
        }
        ArrayList<Line> lines = new ArrayList<Line>(this.source.batchSize());
        for (int j = 0; j < this.source.batchSize(); ++j) {
            Object[] values;
            if (this.result.next()) {
                int n = this.columns.length;
                values = new Object[n];
                for (int i = 1; i <= n; ++i) {
                    Object value = this.result.getObject(i);
                    if (value == null) {
                        value = "NULL";
                    }
                    values[i - 1] = value;
                }
            } else {
                this.done = true;
                break;
            }
            String rawLine = StringUtils.join((Object[])values, (String)",");
            Line line = new Line(rawLine, this.columns, values);
            lines.add(line);
        }
        return lines;
    }

    public String buildSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ");
        sb.append(this.source.table());
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.source.getWhere()})) {
            sb.append(" where " + this.source.getWhere().trim());
        }
        return sb.toString();
    }
}

