/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.loader.exception.InitException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.reader.AbstractReader;
import org.apache.hugegraph.loader.reader.graph.GraphFetcher;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.graph.GraphSource;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.schema.VertexLabel;

public class GraphReader
extends AbstractReader {
    private final GraphSource source;
    private HugeClient sourceClient;
    private GraphFetcher fetcher;
    private Map<String, List<String>> selectedVertices = new HashMap<String, List<String>>();
    private Map<String, Map<String, Object>> selectedVerticesConds = new HashMap<String, Map<String, Object>>();
    private Map<String, List<String>> ignoredVertices = new HashMap<String, List<String>>();
    private Map<String, List<String>> selectedEdges = new HashMap<String, List<String>>();
    private Map<String, Map<String, Object>> selectedEdgesConds = new HashMap<String, Map<String, Object>>();
    private Map<String, List<String>> ignoredEdges = new HashMap<String, List<String>>();
    private Iterator<String> selectedVertexLabels;
    private Iterator<String> selectedEdgeLabels;

    public GraphReader(GraphSource source) {
        this.source = source;
    }

    public GraphReader newGraphReader(InputSource source, Map<String, List<String>> selectedVertices, Map<String, Map<String, Object>> selectedVerticesConds, Map<String, List<String>> ignoredVertices, Map<String, List<String>> selectedEdges, Map<String, Map<String, Object>> selectedEdgesConds, Map<String, List<String>> ignoredEdges) {
        GraphReader reader = new GraphReader((GraphSource)source);
        reader.selectedVertices = selectedVertices;
        reader.selectedVerticesConds = selectedVerticesConds;
        reader.ignoredVertices = ignoredVertices;
        reader.selectedEdges = selectedEdges;
        reader.selectedEdgesConds = selectedEdgesConds;
        reader.ignoredEdges = ignoredEdges;
        reader.selectedVertexLabels = selectedVertices.keySet().iterator();
        reader.selectedEdgeLabels = selectedEdges.keySet().iterator();
        reader.newNextGraphFetcher();
        return reader;
    }

    @Override
    public void init(LoadContext context, InputStruct struct) throws InitException {
        Set properties;
        VertexLabel vl;
        this.progress(context, struct);
        this.sourceClient = this.source.createHugeClient();
        this.sourceClient.assignGraph(this.source.getGraphSpace(), this.source.getGraph());
        if (this.source.getSelectedVertices() != null) {
            for (GraphSource.SelectedLabelDes selected : this.source.getSelectedVertices()) {
                this.selectedVertices.put(selected.getLabel(), null);
                if (selected.getQuery() != null && selected.getQuery().size() > 0) {
                    this.selectedVerticesConds.put(selected.getLabel(), selected.getQuery());
                }
                if (selected.getProperties() == null) continue;
                vl = this.sourceClient.schema().getVertexLabel(selected.getLabel());
                properties = vl.properties();
                properties.removeAll(selected.getProperties());
                this.ignoredVertices.put(selected.getLabel(), new ArrayList(properties));
            }
        } else {
            for (VertexLabel label : this.sourceClient.schema().getVertexLabels()) {
                this.selectedVertices.put(label.name(), null);
            }
        }
        if (this.source.getIgnoredVertices() != null) {
            for (GraphSource.IgnoredLabelDes ignored : this.source.getIgnoredVertices()) {
                if (ignored.getProperties() == null) {
                    this.selectedVertices.remove(ignored.getLabel());
                    continue;
                }
                this.ignoredVertices.put(ignored.getLabel(), ignored.getProperties());
            }
        }
        if (this.source.getSelectedEdges() != null) {
            for (GraphSource.SelectedLabelDes selected : this.source.getSelectedEdges()) {
                this.selectedEdges.put(selected.getLabel(), null);
                if (selected.getQuery() != null && selected.getQuery().size() > 0) {
                    this.selectedEdgesConds.put(selected.getLabel(), selected.getQuery());
                }
                if (selected.getProperties() == null) continue;
                vl = this.sourceClient.schema().getEdgeLabel(selected.getLabel());
                properties = vl.properties();
                properties.removeAll(selected.getProperties());
                this.ignoredEdges.put(selected.getLabel(), new ArrayList(properties));
            }
        } else {
            for (VertexLabel label : this.sourceClient.schema().getEdgeLabels()) {
                this.selectedEdges.put(label.name(), null);
            }
        }
        if (this.source.getIgnoredEdges() != null) {
            for (GraphSource.IgnoredLabelDes ignored : this.source.getIgnoredEdges()) {
                if (CollectionUtils.isEmpty(ignored.getProperties())) {
                    this.selectedEdges.remove(ignored.getLabel());
                    continue;
                }
                this.ignoredEdges.put(ignored.getLabel(), ignored.getProperties());
            }
        }
        this.selectedVertexLabels = this.selectedVertices.keySet().iterator();
        this.selectedEdgeLabels = this.selectedEdges.keySet().iterator();
        this.newNextGraphFetcher();
    }

    @Override
    public void confirmOffset() {
    }

    @Override
    public void close() {
        if (this.sourceClient != null) {
            this.sourceClient.close();
        }
    }

    @Override
    public boolean multiReaders() {
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.fetcher == null) {
            return false;
        }
        if (this.fetcher.hasNext()) {
            return true;
        }
        this.newNextGraphFetcher();
        if (this.fetcher != null) {
            return this.fetcher.hasNext();
        }
        return false;
    }

    private void newNextGraphFetcher() {
        if (this.selectedVertexLabels.hasNext()) {
            String label = this.selectedVertexLabels.next();
            this.fetcher = new GraphFetcher(this.sourceClient, label, this.selectedVerticesConds.get(label), this.source.getBatchSize(), true, this.ignoredVertices.get(label));
        } else if (this.selectedEdgeLabels.hasNext()) {
            String label = this.selectedEdgeLabels.next();
            this.fetcher = new GraphFetcher(this.sourceClient, label, this.selectedEdgesConds.get(label), this.source.getBatchSize(), false, this.ignoredEdges.get(label));
        } else {
            this.fetcher = null;
        }
    }

    @Override
    public Line next() {
        GraphElement element = this.fetcher.next();
        return new Line("", new String[]{"fake"}, new Object[]{element});
    }
}

