/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.failure;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.io.IOUtils;
import org.apache.hugegraph.loader.exception.InsertException;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.exception.ParseException;
import org.apache.hugegraph.loader.exception.ReadException;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class FailWriter {
    private static final Logger LOG = Log.logger(FailWriter.class);
    private final File file;
    private final BufferedWriter writer;

    public FailWriter(File file, String charset, boolean append) {
        FailWriter.checkFileAvailable(file);
        this.file = file;
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file, append);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)stream, charset);
            this.writer = new BufferedWriter(streamWriter);
        }
        catch (IOException e) {
            if (stream != null) {
                IOUtils.closeQuietly((OutputStream)stream);
            }
            throw new LoadException("Failed to create writer for file '%s'", (Throwable)e, file);
        }
    }

    public void write(ReadException e) {
        try {
            this.writeLine("#### READ ERROR: " + e.getMessage());
            this.writeLine(e.line());
        }
        catch (IOException ex) {
            throw new LoadException("Failed to write read error '%s'", (Throwable)ex, e.line());
        }
    }

    public void write(ParseException e) {
        try {
            this.writeLine("#### PARSE ERROR: " + e.getMessage());
            this.writeLine(e.line());
        }
        catch (IOException ex) {
            throw new LoadException("Failed to write parse error '%s'", (Throwable)ex, e.line());
        }
    }

    public void write(InsertException e) {
        try {
            this.writeLine("#### INSERT ERROR: " + e.getMessage());
            this.writeLine(e.line());
        }
        catch (IOException ex) {
            throw new LoadException("Failed to write insert error '%s'", (Throwable)ex, e.line());
        }
    }

    private void writeLine(String line) throws IOException {
        this.writer.write(line);
        this.writer.newLine();
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close writer for file '{}'", (Object)this.file);
        }
    }

    private static void checkFileAvailable(File file) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                return;
            }
            catch (IOException e) {
                throw new LoadException("Failed to create new file '%s'", (Throwable)e, file);
            }
        }
        if (file.isDirectory()) {
            throw new LoadException("Please ensure there is no directory with the same name: '%s'", file);
        }
        if (file.length() > 0L) {
            LOG.warn("The existed file {} will be overwritten", (Object)file);
        }
        if (!file.canWrite()) {
            throw new LoadException("Please ensure the existed file is writable: '%s'", file);
        }
    }
}

