/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import java.io.Serializable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.status.RemoteSparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobRef;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.RemoteSparkJobStatus;
import org.apache.hive.spark.client.JobHandle;

public class RemoteSparkJobRef
implements SparkJobRef {
    private final String jobId;
    private final HiveConf hiveConf;
    private final RemoteSparkJobStatus sparkJobStatus;
    private final JobHandle<Serializable> jobHandler;

    public RemoteSparkJobRef(HiveConf hiveConf, JobHandle<Serializable> jobHandler, RemoteSparkJobStatus sparkJobStatus) {
        this.jobHandler = jobHandler;
        this.jobId = jobHandler.getClientJobId();
        this.hiveConf = hiveConf;
        this.sparkJobStatus = sparkJobStatus;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public SparkJobStatus getSparkJobStatus() {
        return this.sparkJobStatus;
    }

    @Override
    public boolean cancelJob() {
        return this.jobHandler.cancel(true);
    }

    @Override
    public int monitorJob() {
        RemoteSparkJobMonitor remoteSparkJobMonitor = new RemoteSparkJobMonitor(this.hiveConf, this.sparkJobStatus);
        return remoteSparkJobMonitor.startMonitor();
    }
}

