/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class OptionHolder {
    private static final Logger LOG = Log.logger(HugeConfig.class);
    protected Map<String, TypedOption<?, ?>> options = new HashMap();

    protected void registerOptions() {
        for (Field field : this.getClass().getFields()) {
            if (!TypedOption.class.isAssignableFrom(field.getType())) continue;
            try {
                TypedOption option = (TypedOption)field.get(this);
                this.options.putIfAbsent(option.name(), option);
            }
            catch (Exception e) {
                LOG.error("Failed to register option: {}", (Object)field, (Object)e);
                throw new ConfigException("Failed to register option: %s", field);
            }
        }
    }

    public Map<String, TypedOption<?, ?>> options() {
        return Collections.unmodifiableMap(this.options);
    }
}

