/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.concurrent;

import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class PausableScheduledThreadPool
extends ScheduledThreadPoolExecutor {
    private static final Logger LOG = Log.logger(PausableScheduledThreadPool.class);
    private volatile boolean paused = false;

    public PausableScheduledThreadPool(int corePoolSize, ThreadFactory factory) {
        super(corePoolSize, factory);
    }

    public synchronized void pauseSchedule() {
        this.paused = true;
        LOG.info("PausableScheduledThreadPool was paused");
    }

    public synchronized void resumeSchedule() {
        this.paused = false;
        this.notifyAll();
        LOG.info("PausableScheduledThreadPool was resumed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        PausableScheduledThreadPool pausableScheduledThreadPool = this;
        synchronized (pausableScheduledThreadPool) {
            while (this.paused) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn("PausableScheduledThreadPool was interrupted");
                }
            }
        }
        super.beforeExecute(t, r);
    }

    @Override
    public void shutdown() {
        if (this.paused) {
            this.resumeSchedule();
        }
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.paused) {
            this.resumeSchedule();
        }
        return super.shutdownNow();
    }
}

