/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import org.apache.hugegraph.util.E;

public final class UnitUtil {
    public static double bytesToMB(long bytes) {
        return UnitUtil.doubleWith2Scale((double)bytes / 1048576.0);
    }

    public static double bytesToGB(long bytes) {
        return UnitUtil.doubleWith2Scale((double)bytes / 1.073741824E9);
    }

    public static double doubleWith2Scale(double value) {
        BigDecimal decimal = new BigDecimal(value);
        return decimal.setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public static String bytesToReadableString(long bytes) {
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
        if (bytes <= 0L) {
            return "0 B";
        }
        int i = (int)(Math.log(bytes) / Math.log(1024.0));
        E.checkArgument(i < units.length, "The bytes parameter is out of %s unit: %s", units[units.length - 1], bytes);
        double value = (double)bytes / Math.pow(1024.0, i);
        if (value % 1.0 == 0.0) {
            return (long)value + " " + units[i];
        }
        return UnitUtil.doubleWith2Scale(value) + " " + units[i];
    }

    public static long bytesFromReadableString(String valueWithUnit) {
        double value;
        long factor;
        int spacePos = valueWithUnit.indexOf(" ");
        E.checkArgument(spacePos >= 0, "Invalid readable bytes '%s', expect format like '10 MB'", valueWithUnit);
        String unit = valueWithUnit.substring(spacePos + 1);
        switch (unit.trim().toUpperCase()) {
            case "B": 
            case "BYTE": 
            case "BYTES": {
                factor = 1L;
                break;
            }
            case "KB": 
            case "KIB": {
                factor = 1024L;
                break;
            }
            case "MB": 
            case "MIB": {
                factor = 0x100000L;
                break;
            }
            case "GB": 
            case "GIB": {
                factor = 0x40000000L;
                break;
            }
            case "TB": 
            case "TIB": {
                factor = 0x10000000000L;
                break;
            }
            case "PB": 
            case "PIB": {
                factor = 0x4000000000000L;
                break;
            }
            case "EB": 
            case "EIB": {
                factor = 0x1000000000000000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized unit " + unit);
            }
        }
        try {
            value = Double.parseDouble(valueWithUnit.substring(0, spacePos));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid parameter(not number): '%s'", valueWithUnit), e);
        }
        E.checkArgument((value *= (double)factor) <= 9.223372036854776E18, "The value %s from parameter '%s' is out of range", value, valueWithUnit);
        return (long)value;
    }

    public static String timestampToReadableString(long time) {
        Duration duration = Duration.ofMillis(time);
        long days = duration.toDays();
        long hours = duration.toHours();
        long minutes = duration.toMinutes();
        long seconds = duration.getSeconds();
        if (days > 0L) {
            return String.format("%dd%dh%dm%ds", days, hours % 24L, minutes % 60L, seconds % 60L);
        }
        if (hours > 0L) {
            return String.format("%dh%dm%ds", hours, minutes % 60L, seconds % 60L);
        }
        if (minutes > 0L) {
            return String.format("%dm%ds", minutes, seconds % 60L);
        }
        if (seconds > 0L) {
            long ms = duration.toMillis() % 1000L;
            if (ms > 0L) {
                return String.format("%ds%dms", seconds, ms);
            }
            return String.format("%ds", seconds);
        }
        return String.format("%dms", duration.toMillis());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long timestampFromReadableString(String valueWithUnit) {
        long ms = 0L;
        String formatDuration = valueWithUnit.toUpperCase();
        if (formatDuration.indexOf(68) >= 0) {
            assert (!formatDuration.contains("MS"));
            formatDuration = "P" + formatDuration.replace("D", "DT");
        } else {
            int msPos = formatDuration.indexOf("MS");
            if (msPos >= 0) {
                int sPos = formatDuration.indexOf("S");
                if (0 > sPos) return Long.parseLong(formatDuration.substring(0, msPos));
                if (sPos >= msPos) return Long.parseLong(formatDuration.substring(0, msPos));
                ms = Long.parseLong(formatDuration.substring(++sPos, msPos));
                ms %= 1000L;
                formatDuration = formatDuration.substring(0, sPos);
            } else assert (formatDuration.endsWith("S"));
            formatDuration = "PT" + formatDuration;
        }
        Duration duration = Duration.parse(formatDuration);
        return duration.toMillis() + ms;
    }
}

