/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.filter.util;

import com.beust.jcommander.IStringConverter;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.structure.constant.DataType;

public class ShortIdConfig {
    private String vertexLabel;
    private String idFieldName;
    private DataType idFieldType;
    private String primaryKeyField;
    private long labelID;

    public String getVertexLabel() {
        return this.vertexLabel;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public DataType getIdFieldType() {
        return this.idFieldType;
    }

    public void setPrimaryKeyField(String primaryKeyField) {
        this.primaryKeyField = primaryKeyField;
    }

    public String getPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public long getLabelID() {
        return this.labelID;
    }

    public void setLabelID(long labelID) {
        this.labelID = labelID;
    }

    public static class ShortIdConfigConverter
    implements IStringConverter<ShortIdConfig> {
        public ShortIdConfig convert(String s) {
            String[] sp = s.split(":");
            ShortIdConfig config = new ShortIdConfig();
            config.vertexLabel = sp[0];
            config.idFieldName = sp[1];
            String a = DataType.BYTE.name();
            switch (sp[2]) {
                case "boolean": {
                    config.idFieldType = DataType.BOOLEAN;
                    break;
                }
                case "byte": {
                    config.idFieldType = DataType.BYTE;
                    break;
                }
                case "int": {
                    config.idFieldType = DataType.INT;
                    break;
                }
                case "long": {
                    config.idFieldType = DataType.LONG;
                    break;
                }
                case "float": {
                    config.idFieldType = DataType.FLOAT;
                    break;
                }
                case "double": {
                    config.idFieldType = DataType.DOUBLE;
                    break;
                }
                case "text": {
                    config.idFieldType = DataType.TEXT;
                    break;
                }
                case "blob": {
                    config.idFieldType = DataType.BLOB;
                    break;
                }
                case "date": {
                    config.idFieldType = DataType.DATE;
                    break;
                }
                case "uuid": {
                    config.idFieldType = DataType.UUID;
                    break;
                }
                default: {
                    throw new LoadException("unknow type " + sp[2]);
                }
            }
            return config;
        }
    }
}

