/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.failure;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.loader.exception.InsertException;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.exception.ParseException;
import org.apache.hugegraph.loader.exception.ReadException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.failure.FailWriter;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.util.LoadUtil;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class FailLogger {
    private static final Logger LOG = Log.logger(FailLogger.class);
    private final LoadOptions options;
    private final InputStruct struct;
    private final File file;
    private final FailWriter writer;

    public FailLogger(LoadContext context, InputStruct struct) {
        boolean append;
        this.options = context.options();
        this.struct = struct;
        String prefix = LoadUtil.getStructDirPrefix(context.options());
        String parentDir = Paths.get(prefix, "failure-data").toString();
        String fileName = this.struct.id() + ".error";
        if (this.options.incrementalMode) {
            append = true;
        } else if (this.options.failureMode) {
            fileName = fileName + ".temp";
            append = false;
        } else {
            append = false;
        }
        String savePath = Paths.get(parentDir, fileName).toString();
        LOG.info("The failure data path of input struct {} is at {}: ", (Object)struct.id(), (Object)savePath);
        this.file = new File(savePath);
        String charset = this.struct.input().charset();
        this.writer = new FailWriter(this.file, charset, append);
    }

    public void write(ReadException e) {
        this.writer.write(e);
    }

    public void write(ParseException e) {
        this.writer.write(e);
    }

    public void write(InsertException e) {
        this.writer.write(e);
    }

    public void close() {
        this.writeHeaderIfNeeded();
        this.writer.close();
        if (this.file.length() == 0L) {
            LOG.debug("The file {} is empty, delete it", (Object)this.file);
            this.file.delete();
        } else {
            this.removeDupLines();
            this.renameTempFile();
        }
    }

    private void writeHeaderIfNeeded() {
        if (this.struct.input().header() == null) {
            return;
        }
        String header = JsonUtil.toJson((Object)this.struct.input().header());
        String fileName = this.struct.id() + ".header";
        String filePath = Paths.get(this.file.getParent(), fileName).toString();
        File headerFile = new File(filePath);
        String charset = this.struct.input().charset();
        try {
            FileUtils.writeStringToFile((File)headerFile, (String)header, (String)charset);
        }
        catch (IOException e) {
            throw new LoadException("Failed to write header '%s'", e);
        }
    }

    private void removeDupLines() {
        Charset charset = Charset.forName(this.struct.input().charset());
        File dedupFile = new File(this.file.getAbsolutePath() + ".dedup");
        try (FileInputStream is = new FileInputStream(this.file);
             InputStreamReader ir = new InputStreamReader((InputStream)is, charset);
             BufferedReader reader = new BufferedReader(ir);
             FileOutputStream os = new FileOutputStream(dedupFile);
             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)os, charset);
             BufferedWriter writer = new BufferedWriter(ow);){
            String dataLine;
            String tipsLine;
            HashSet<Integer> writtenLines = new HashSet<Integer>();
            HashFunction hashFunc = Hashing.murmur3_32();
            while ((tipsLine = reader.readLine()) != null && (dataLine = reader.readLine()) != null) {
                int hash = hashFunc.hashString((CharSequence)dataLine, charset).asInt();
                if (writtenLines.contains(hash)) continue;
                writer.write(tipsLine);
                writer.newLine();
                writer.write(dataLine);
                writer.newLine();
                writtenLines.add(hash);
            }
        }
        catch (IOException e) {
            throw new LoadException("Failed to remove duplicate lines");
        }
        if (!dedupFile.renameTo(this.file)) {
            throw new LoadException("Failed to rename dedup file to origin");
        }
    }

    private void renameTempFile() {
        int idx;
        String fileName;
        String destName;
        boolean needRename = this.options.failureMode;
        if (needRename && !this.file.renameTo(new File(destName = (fileName = this.file.getAbsolutePath()).substring(0, idx = fileName.lastIndexOf(".temp"))))) {
            LOG.warn("Failed to rename failure data file {} to {}", (Object)fileName, (Object)destName);
        }
    }
}

