/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.token.Token;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RequestConverter {
    private static AdminProtos.RollWALWriterRequest ROLL_WAL_WRITER_REQUEST = AdminProtos.RollWALWriterRequest.newBuilder().build();
    private static AdminProtos.GetServerInfoRequest GET_SERVER_INFO_REQUEST = AdminProtos.GetServerInfoRequest.newBuilder().build();
    private static final MasterProtos.RunCatalogScanRequest CATALOG_SCAN_REQUEST = MasterProtos.RunCatalogScanRequest.newBuilder().build();
    private static final MasterProtos.IsCatalogJanitorEnabledRequest IS_CATALOG_JANITOR_ENABLED_REQUEST = MasterProtos.IsCatalogJanitorEnabledRequest.newBuilder().build();
    private static final MasterProtos.RunCleanerChoreRequest CLEANER_CHORE_REQUEST = MasterProtos.RunCleanerChoreRequest.newBuilder().build();
    private static final MasterProtos.IsCleanerChoreEnabledRequest IS_CLEANER_CHORE_ENABLED_REQUEST = MasterProtos.IsCleanerChoreEnabledRequest.newBuilder().build();
    private static final QuotaProtos.GetSpaceQuotaRegionSizesRequest GET_SPACE_QUOTA_REGION_SIZES_REQUEST = QuotaProtos.GetSpaceQuotaRegionSizesRequest.newBuilder().build();
    private static final QuotaProtos.GetSpaceQuotaSnapshotsRequest GET_SPACE_QUOTA_SNAPSHOTS_REQUEST = QuotaProtos.GetSpaceQuotaSnapshotsRequest.newBuilder().build();
    private static final QuotaProtos.GetQuotaStatesRequest GET_QUOTA_STATES_REQUEST = QuotaProtos.GetQuotaStatesRequest.newBuilder().build();

    private RequestConverter() {
    }

    public static ClientProtos.GetRequest buildGetRequest(byte[] regionName, Get get) throws IOException {
        ClientProtos.GetRequest.Builder builder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setGet(ProtobufUtil.toGet(get));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildIncrementRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability, long nonceGroup, long nonce) {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(UnsafeByteOperations.unsafeWrap((byte[])row));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        mutateBuilder.setDurability(ProtobufUtil.toDurability(durability));
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        columnBuilder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])family));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        valueBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])Bytes.toBytes((long)amount)));
        valueBuilder.setQualifier(UnsafeByteOperations.unsafeWrap((byte[])(qualifier == null ? HConstants.EMPTY_BYTE_ARRAY : qualifier)));
        valueBuilder.setTimestamp(Long.MAX_VALUE);
        columnBuilder.addQualifierValue(valueBuilder.build());
        mutateBuilder.addColumnValue(columnBuilder.build());
        if (nonce != 0L) {
            mutateBuilder.setNonce(nonce);
        }
        builder.setMutation(mutateBuilder.build());
        if (nonceGroup != 0L) {
            builder.setNonceGroup(nonceGroup);
        }
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, TimeRange timeRange, Put put) throws IOException {
        return RequestConverter.buildMutateRequest(regionName, row, family, qualifier, comparator, compareType, timeRange, put, ClientProtos.MutationProto.MutationType.PUT);
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, TimeRange timeRange, Delete delete) throws IOException {
        return RequestConverter.buildMutateRequest(regionName, row, family, qualifier, comparator, compareType, timeRange, delete, ClientProtos.MutationProto.MutationType.DELETE);
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, TimeRange timeRange, Mutation mutation, ClientProtos.MutationProto.MutationType type) throws IOException {
        return ClientProtos.MutateRequest.newBuilder().setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName)).setMutation(ProtobufUtil.toMutation(type, mutation)).setCondition(RequestConverter.buildCondition(row, family, qualifier, comparator, compareType, timeRange)).build();
    }

    public static ClientProtos.MultiRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, TimeRange timeRange, RowMutations rowMutations) throws IOException {
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(ClientProtos.RegionAction.newBuilder(), regionName);
        builder.setAtomic(true);
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto.MutationType mutateType = null;
            if (mutation instanceof Put) {
                mutateType = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                mutateType = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            mutationBuilder.clear();
            ClientProtos.MutationProto mp = ProtobufUtil.toMutation(mutateType, mutation, mutationBuilder);
            actionBuilder.clear();
            actionBuilder.setMutation(mp);
            builder.addAction(actionBuilder.build());
        }
        return ClientProtos.MultiRequest.newBuilder().addRegionAction(builder.build()).setCondition(RequestConverter.buildCondition(row, family, qualifier, comparator, compareType, timeRange)).build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Put put) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, (Mutation)put, ClientProtos.MutationProto.newBuilder()));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Append append, long nonceGroup, long nonce) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (nonce != 0L && nonceGroup != 0L) {
            builder.setNonceGroup(nonceGroup);
        }
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.APPEND, append, ClientProtos.MutationProto.newBuilder(), nonce));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Increment increment, long nonceGroup, long nonce) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (nonce != 0L && nonceGroup != 0L) {
            builder.setNonceGroup(nonceGroup);
        }
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.INCREMENT, increment, ClientProtos.MutationProto.newBuilder(), nonce));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Delete delete) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)delete, ClientProtos.MutationProto.newBuilder()));
        return builder.build();
    }

    public static ClientProtos.RegionAction.Builder buildRegionAction(byte[] regionName, RowMutations rowMutations) throws IOException {
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(ClientProtos.RegionAction.newBuilder(), regionName);
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto.MutationType mutateType = null;
            if (mutation instanceof Put) {
                mutateType = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                mutateType = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            mutationBuilder.clear();
            ClientProtos.MutationProto mp = ProtobufUtil.toMutation(mutateType, mutation, mutationBuilder);
            actionBuilder.clear();
            actionBuilder.setMutation(mp);
            builder.addAction(actionBuilder.build());
        }
        return builder;
    }

    public static ClientProtos.RegionAction.Builder buildNoDataRegionAction(byte[] regionName, RowMutations rowMutations, List<CellScannable> cells, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto.MutationType type = null;
            if (mutation instanceof Put) {
                type = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                type = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            mutationBuilder.clear();
            ClientProtos.MutationProto mp = ProtobufUtil.toMutationNoData(type, mutation, mutationBuilder);
            cells.add(mutation);
            actionBuilder.clear();
            regionActionBuilder.addAction(actionBuilder.setMutation(mp).build());
        }
        return regionActionBuilder;
    }

    public static ClientProtos.RegionAction.Builder getRegionActionBuilderWithRegion(ClientProtos.RegionAction.Builder regionActionBuilder, byte[] regionName) {
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        regionActionBuilder.setRegion(region);
        return regionActionBuilder;
    }

    public static ClientProtos.ScanRequest buildScanRequest(byte[] regionName, Scan scan, int numberOfRows, boolean closeScanner) throws IOException {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setRegion(region);
        builder.setScan(ProtobufUtil.toScan(scan));
        builder.setClientHandlesPartials(true);
        builder.setClientHandlesHeartbeats(true);
        builder.setTrackScanMetrics(scan.isScanMetricsEnabled());
        if (scan.getLimit() > 0) {
            builder.setLimitOfRows(scan.getLimit());
        }
        return builder.build();
    }

    public static ClientProtos.ScanRequest buildScanRequest(long scannerId, int numberOfRows, boolean closeScanner, boolean trackMetrics) {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setScannerId(scannerId);
        builder.setClientHandlesPartials(true);
        builder.setClientHandlesHeartbeats(true);
        builder.setTrackScanMetrics(trackMetrics);
        return builder.build();
    }

    public static ClientProtos.ScanRequest buildScanRequest(long scannerId, int numberOfRows, boolean closeScanner, long nextCallSeq, boolean trackMetrics, boolean renew, int limitOfRows) {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setScannerId(scannerId);
        builder.setNextCallSeq(nextCallSeq);
        builder.setClientHandlesPartials(true);
        builder.setClientHandlesHeartbeats(true);
        builder.setTrackScanMetrics(trackMetrics);
        builder.setRenew(renew);
        if (limitOfRows > 0) {
            builder.setLimitOfRows(limitOfRows);
        }
        return builder.build();
    }

    public static ClientProtos.BulkLoadHFileRequest buildBulkLoadHFileRequest(List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum, Token<?> userToken, String bulkToken) {
        return RequestConverter.buildBulkLoadHFileRequest(familyPaths, regionName, assignSeqNum, userToken, bulkToken, false, null, true);
    }

    public static ClientProtos.BulkLoadHFileRequest buildBulkLoadHFileRequest(List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum, Token<?> userToken, String bulkToken, boolean copyFiles, List<String> clusterIds, boolean replicate) {
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        ClientProtos.DelegationToken protoDT = null;
        if (userToken != null) {
            protoDT = ClientProtos.DelegationToken.newBuilder().setIdentifier(UnsafeByteOperations.unsafeWrap((byte[])userToken.getIdentifier())).setPassword(UnsafeByteOperations.unsafeWrap((byte[])userToken.getPassword())).setKind(userToken.getKind().toString()).setService(userToken.getService().toString()).build();
        }
        ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath> protoFamilyPaths = new ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath>(familyPaths.size());
        if (!familyPaths.isEmpty()) {
            ClientProtos.BulkLoadHFileRequest.FamilyPath.Builder pathBuilder = ClientProtos.BulkLoadHFileRequest.FamilyPath.newBuilder();
            for (Pair<byte[], String> el : familyPaths) {
                protoFamilyPaths.add(pathBuilder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])((byte[])el.getFirst()))).setPath((String)el.getSecond()).build());
            }
            pathBuilder.clear();
        }
        ClientProtos.BulkLoadHFileRequest.Builder request = ClientProtos.BulkLoadHFileRequest.newBuilder().setRegion(region).setAssignSeqNum(assignSeqNum).addAllFamilyPath(protoFamilyPaths);
        if (userToken != null) {
            request.setFsToken(protoDT);
        }
        if (bulkToken != null) {
            request.setBulkToken(bulkToken);
        }
        request.setCopyFile(copyFiles);
        if (clusterIds != null) {
            request.addAllClusterIds(clusterIds);
        }
        request.setReplicate(replicate);
        return request.build();
    }

    public static void buildRegionActions(byte[] regionName, List<Action> actions, ClientProtos.MultiRequest.Builder multiRequestBuilder, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder, long nonceGroup, Map<Integer, Integer> rowMutationsIndexMap) throws IOException {
        regionActionBuilder.clear();
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(regionActionBuilder, regionName);
        ClientProtos.CoprocessorServiceCall.Builder cpBuilder = null;
        boolean hasNonce = false;
        ArrayList<Action> rowMutationsList = new ArrayList<Action>();
        for (Action action : actions) {
            Row row = action.getAction();
            actionBuilder.clear();
            actionBuilder.setIndex(action.getOriginalIndex());
            mutationBuilder.clear();
            if (row instanceof Get) {
                Get g = (Get)row;
                builder.addAction(actionBuilder.setGet(ProtobufUtil.toGet(g)));
                continue;
            }
            if (row instanceof Put) {
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, (Mutation)((Put)row), mutationBuilder)));
                continue;
            }
            if (row instanceof Delete) {
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)((Delete)row), mutationBuilder)));
                continue;
            }
            if (row instanceof Append) {
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.APPEND, (Append)row, mutationBuilder, action.getNonce())));
                hasNonce = true;
                continue;
            }
            if (row instanceof Increment) {
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.INCREMENT, (Increment)row, mutationBuilder, action.getNonce())));
                hasNonce = true;
                continue;
            }
            if (row instanceof RegionCoprocessorServiceExec) {
                RegionCoprocessorServiceExec exec = (RegionCoprocessorServiceExec)row;
                ByteString value = UnsafeByteOperations.unsafeWrap((byte[])exec.getRequest().toByteArray());
                if (cpBuilder == null) {
                    cpBuilder = ClientProtos.CoprocessorServiceCall.newBuilder();
                } else {
                    cpBuilder.clear();
                }
                builder.addAction(actionBuilder.setServiceCall(cpBuilder.setRow(UnsafeByteOperations.unsafeWrap((byte[])exec.getRow())).setServiceName(exec.getMethod().getService().getFullName()).setMethodName(exec.getMethod().getName()).setRequest(value)));
                continue;
            }
            if (row instanceof RowMutations) {
                rowMutationsList.add(action);
                continue;
            }
            throw new DoNotRetryIOException("Multi doesn't support " + row.getClass().getName());
        }
        if (!multiRequestBuilder.hasNonceGroup() && hasNonce) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
        multiRequestBuilder.addRegionAction(builder.build());
        for (Action action : rowMutationsList) {
            RowMutations rms = (RowMutations)action.getAction();
            ClientProtos.RegionAction.Builder rowMutationsRegionActionBuilder = RequestConverter.buildRegionAction(regionName, rms);
            rowMutationsRegionActionBuilder.setAtomic(true);
            multiRequestBuilder.addRegionAction(rowMutationsRegionActionBuilder.build());
            rowMutationsIndexMap.put(multiRequestBuilder.getRegionActionCount() - 1, action.getOriginalIndex());
        }
    }

    public static void buildNoDataRegionActions(byte[] regionName, Iterable<Action> actions, List<CellScannable> cells, ClientProtos.MultiRequest.Builder multiRequestBuilder, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder, long nonceGroup, Map<Integer, Integer> rowMutationsIndexMap) throws IOException {
        regionActionBuilder.clear();
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(regionActionBuilder, regionName);
        ClientProtos.CoprocessorServiceCall.Builder cpBuilder = null;
        ClientProtos.RegionAction.Builder rowMutationsRegionActionBuilder = null;
        boolean hasNonce = false;
        ArrayList<Action> rowMutationsList = new ArrayList<Action>();
        for (Action action : actions) {
            Row row = action.getAction();
            actionBuilder.clear();
            actionBuilder.setIndex(action.getOriginalIndex());
            mutationBuilder.clear();
            if (row instanceof Get) {
                Get g = (Get)row;
                builder.addAction(actionBuilder.setGet(ProtobufUtil.toGet(g)));
                continue;
            }
            if (row instanceof Put) {
                Put p = (Put)row;
                cells.add(p);
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.PUT, p, mutationBuilder)));
                continue;
            }
            if (row instanceof Delete) {
                Delete d = (Delete)row;
                int size = d.size();
                if (size > 0) {
                    cells.add(d);
                    builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.DELETE, d, mutationBuilder)));
                    continue;
                }
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)d, mutationBuilder)));
                continue;
            }
            if (row instanceof Append) {
                Append a = (Append)row;
                cells.add(a);
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.APPEND, a, mutationBuilder, action.getNonce())));
                hasNonce = true;
                continue;
            }
            if (row instanceof Increment) {
                Increment i = (Increment)row;
                cells.add(i);
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.INCREMENT, i, mutationBuilder, action.getNonce())));
                hasNonce = true;
                continue;
            }
            if (row instanceof RegionCoprocessorServiceExec) {
                RegionCoprocessorServiceExec exec = (RegionCoprocessorServiceExec)row;
                ByteString value = UnsafeByteOperations.unsafeWrap((byte[])exec.getRequest().toByteArray());
                if (cpBuilder == null) {
                    cpBuilder = ClientProtos.CoprocessorServiceCall.newBuilder();
                } else {
                    cpBuilder.clear();
                }
                builder.addAction(actionBuilder.setServiceCall(cpBuilder.setRow(UnsafeByteOperations.unsafeWrap((byte[])exec.getRow())).setServiceName(exec.getMethod().getService().getFullName()).setMethodName(exec.getMethod().getName()).setRequest(value)));
                continue;
            }
            if (row instanceof RowMutations) {
                rowMutationsList.add(action);
                continue;
            }
            throw new DoNotRetryIOException("Multi doesn't support " + row.getClass().getName());
        }
        if (!multiRequestBuilder.hasNonceGroup() && hasNonce) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
        multiRequestBuilder.addRegionAction(builder.build());
        for (Action action : rowMutationsList) {
            RowMutations rms = (RowMutations)action.getAction();
            if (rowMutationsRegionActionBuilder == null) {
                rowMutationsRegionActionBuilder = ClientProtos.RegionAction.newBuilder();
            } else {
                rowMutationsRegionActionBuilder.clear();
            }
            rowMutationsRegionActionBuilder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
            rowMutationsRegionActionBuilder = RequestConverter.buildNoDataRegionAction(regionName, rms, cells, rowMutationsRegionActionBuilder, actionBuilder, mutationBuilder);
            rowMutationsRegionActionBuilder.setAtomic(true);
            multiRequestBuilder.addRegionAction(rowMutationsRegionActionBuilder.build());
            rowMutationsIndexMap.put(multiRequestBuilder.getRegionActionCount() - 1, action.getOriginalIndex());
        }
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName) {
        return RequestConverter.buildGetRegionInfoRequest(regionName, false);
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName, boolean includeCompactionState) {
        return RequestConverter.buildGetRegionInfoRequest(regionName, includeCompactionState, false);
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName, boolean includeCompactionState, boolean includeBestSplitRow) {
        AdminProtos.GetRegionInfoRequest.Builder builder = AdminProtos.GetRegionInfoRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (includeCompactionState) {
            builder.setCompactionState(includeCompactionState);
        }
        if (includeBestSplitRow) {
            builder.setBestSplitRow(includeBestSplitRow);
        }
        return builder.build();
    }

    public static AdminProtos.GetRegionLoadRequest buildGetRegionLoadRequest(TableName tableName) {
        AdminProtos.GetRegionLoadRequest.Builder builder = AdminProtos.GetRegionLoadRequest.newBuilder();
        if (tableName != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        }
        return builder.build();
    }

    public static AdminProtos.GetOnlineRegionRequest buildGetOnlineRegionRequest() {
        return AdminProtos.GetOnlineRegionRequest.newBuilder().build();
    }

    public static AdminProtos.FlushRegionRequest buildFlushRegionRequest(byte[] regionName) {
        return RequestConverter.buildFlushRegionRequest(regionName, false);
    }

    public static AdminProtos.FlushRegionRequest buildFlushRegionRequest(byte[] regionName, boolean writeFlushWALMarker) {
        AdminProtos.FlushRegionRequest.Builder builder = AdminProtos.FlushRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setWriteFlushWalMarker(writeFlushWALMarker);
        return builder.build();
    }

    public static AdminProtos.OpenRegionRequest buildOpenRegionRequest(ServerName server, RegionInfo region, List<ServerName> favoredNodes) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        builder.addOpenInfo(RequestConverter.buildRegionOpenInfo(region, favoredNodes, -1L));
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        builder.setMasterSystemTime(EnvironmentEdgeManager.currentTime());
        return builder.build();
    }

    public static AdminProtos.UpdateFavoredNodesRequest buildUpdateFavoredNodesRequest(List<Pair<RegionInfo, List<ServerName>>> updateRegionInfos) {
        AdminProtos.UpdateFavoredNodesRequest.Builder ubuilder = AdminProtos.UpdateFavoredNodesRequest.newBuilder();
        if (updateRegionInfos != null && !updateRegionInfos.isEmpty()) {
            AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo.Builder builder = AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo.newBuilder();
            for (Pair<RegionInfo, List<ServerName>> pair : updateRegionInfos) {
                builder.setRegion(ProtobufUtil.toRegionInfo((RegionInfo)pair.getFirst()));
                for (ServerName server : (List)pair.getSecond()) {
                    builder.addFavoredNodes(ProtobufUtil.toServerName(server));
                }
                ubuilder.addUpdateInfo(builder.build());
                builder.clear();
            }
        }
        return ubuilder.build();
    }

    public static AdminProtos.WarmupRegionRequest buildWarmupRegionRequest(RegionInfo regionInfo) {
        AdminProtos.WarmupRegionRequest.Builder builder = AdminProtos.WarmupRegionRequest.newBuilder();
        builder.setRegionInfo(ProtobufUtil.toRegionInfo(regionInfo));
        return builder.build();
    }

    public static AdminProtos.CompactRegionRequest buildCompactRegionRequest(byte[] regionName, boolean major, byte[] columnFamily) {
        AdminProtos.CompactRegionRequest.Builder builder = AdminProtos.CompactRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMajor(major);
        if (columnFamily != null) {
            builder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])columnFamily));
        }
        return builder.build();
    }

    public static AdminProtos.RollWALWriterRequest buildRollWALWriterRequest() {
        return ROLL_WAL_WRITER_REQUEST;
    }

    public static AdminProtos.GetServerInfoRequest buildGetServerInfoRequest() {
        return GET_SERVER_INFO_REQUEST;
    }

    public static AdminProtos.StopServerRequest buildStopServerRequest(String reason) {
        AdminProtos.StopServerRequest.Builder builder = AdminProtos.StopServerRequest.newBuilder();
        builder.setReason(reason);
        return builder.build();
    }

    public static HBaseProtos.RegionSpecifier buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType type, byte[] value) {
        HBaseProtos.RegionSpecifier.Builder regionBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])value));
        regionBuilder.setType(type);
        return regionBuilder.build();
    }

    public static ClientProtos.Condition buildCondition(byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, TimeRange timeRange) {
        return ClientProtos.Condition.newBuilder().setRow(UnsafeByteOperations.unsafeWrap((byte[])row)).setFamily(UnsafeByteOperations.unsafeWrap((byte[])family)).setQualifier(UnsafeByteOperations.unsafeWrap((byte[])(qualifier == null ? HConstants.EMPTY_BYTE_ARRAY : qualifier))).setComparator(ProtobufUtil.toComparator(comparator)).setCompareType(compareType).setTimeRange(ProtobufUtil.toTimeRange(timeRange)).build();
    }

    public static MasterProtos.AddColumnRequest buildAddColumnRequest(TableName tableName, ColumnFamilyDescriptor column, long nonceGroup, long nonce) {
        MasterProtos.AddColumnRequest.Builder builder = MasterProtos.AddColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnFamilies(ProtobufUtil.toColumnFamilySchema(column));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.DeleteColumnRequest buildDeleteColumnRequest(TableName tableName, byte[] columnName, long nonceGroup, long nonce) {
        MasterProtos.DeleteColumnRequest.Builder builder = MasterProtos.DeleteColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnName(UnsafeByteOperations.unsafeWrap((byte[])columnName));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.ModifyColumnRequest buildModifyColumnRequest(TableName tableName, ColumnFamilyDescriptor column, long nonceGroup, long nonce) {
        MasterProtos.ModifyColumnRequest.Builder builder = MasterProtos.ModifyColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnFamilies(ProtobufUtil.toColumnFamilySchema(column));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.MoveRegionRequest buildMoveRegionRequest(byte[] encodedRegionName, ServerName destServerName) {
        MasterProtos.MoveRegionRequest.Builder builder = MasterProtos.MoveRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedRegionName));
        if (destServerName != null) {
            builder.setDestServerName(ProtobufUtil.toServerName(destServerName));
        }
        return builder.build();
    }

    public static MasterProtos.MergeTableRegionsRequest buildMergeTableRegionsRequest(byte[][] encodedNameOfdaughaterRegions, boolean forcible, long nonceGroup, long nonce) throws DeserializationException {
        MasterProtos.MergeTableRegionsRequest.Builder builder = MasterProtos.MergeTableRegionsRequest.newBuilder();
        for (int i = 0; i < encodedNameOfdaughaterRegions.length; ++i) {
            builder.addRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedNameOfdaughaterRegions[i]));
        }
        builder.setForcible(forcible);
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.SplitTableRegionRequest buildSplitTableRegionRequest(RegionInfo regionInfo, byte[] splitRow, long nonceGroup, long nonce) throws DeserializationException {
        MasterProtos.SplitTableRegionRequest.Builder builder = MasterProtos.SplitTableRegionRequest.newBuilder();
        builder.setRegionInfo(ProtobufUtil.toRegionInfo(regionInfo));
        if (splitRow != null) {
            builder.setSplitRow(UnsafeByteOperations.unsafeWrap((byte[])splitRow));
        }
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.AssignRegionRequest buildAssignRegionRequest(byte[] regionName) {
        MasterProtos.AssignRegionRequest.Builder builder = MasterProtos.AssignRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterProtos.UnassignRegionRequest buildUnassignRegionRequest(byte[] regionName, boolean force) {
        MasterProtos.UnassignRegionRequest.Builder builder = MasterProtos.UnassignRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        builder.setForce(force);
        return builder.build();
    }

    public static MasterProtos.OfflineRegionRequest buildOfflineRegionRequest(byte[] regionName) {
        MasterProtos.OfflineRegionRequest.Builder builder = MasterProtos.OfflineRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterProtos.DeleteTableRequest buildDeleteTableRequest(TableName tableName, long nonceGroup, long nonce) {
        MasterProtos.DeleteTableRequest.Builder builder = MasterProtos.DeleteTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.TruncateTableRequest buildTruncateTableRequest(TableName tableName, boolean preserveSplits, long nonceGroup, long nonce) {
        MasterProtos.TruncateTableRequest.Builder builder = MasterProtos.TruncateTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setPreserveSplits(preserveSplits);
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.EnableTableRequest buildEnableTableRequest(TableName tableName, long nonceGroup, long nonce) {
        MasterProtos.EnableTableRequest.Builder builder = MasterProtos.EnableTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.DisableTableRequest buildDisableTableRequest(TableName tableName, long nonceGroup, long nonce) {
        MasterProtos.DisableTableRequest.Builder builder = MasterProtos.DisableTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.CreateTableRequest buildCreateTableRequest(TableDescriptor tableDescriptor, byte[][] splitKeys, long nonceGroup, long nonce) {
        MasterProtos.CreateTableRequest.Builder builder = MasterProtos.CreateTableRequest.newBuilder();
        builder.setTableSchema(ProtobufUtil.toTableSchema(tableDescriptor));
        if (splitKeys != null) {
            for (byte[] key : splitKeys) {
                builder.addSplitKeys(UnsafeByteOperations.unsafeWrap((byte[])key));
            }
        }
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.ModifyTableRequest buildModifyTableRequest(TableName tableName, TableDescriptor tableDesc, long nonceGroup, long nonce) {
        MasterProtos.ModifyTableRequest.Builder builder = MasterProtos.ModifyTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setTableSchema(ProtobufUtil.toTableSchema(tableDesc));
        builder.setNonceGroup(nonceGroup);
        builder.setNonce(nonce);
        return builder.build();
    }

    public static MasterProtos.GetSchemaAlterStatusRequest buildGetSchemaAlterStatusRequest(TableName tableName) {
        MasterProtos.GetSchemaAlterStatusRequest.Builder builder = MasterProtos.GetSchemaAlterStatusRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        return builder.build();
    }

    public static MasterProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(List<TableName> tableNames) {
        MasterProtos.GetTableDescriptorsRequest.Builder builder = MasterProtos.GetTableDescriptorsRequest.newBuilder();
        if (tableNames != null) {
            for (TableName tableName : tableNames) {
                builder.addTableNames(ProtobufUtil.toProtoTableName(tableName));
            }
        }
        return builder.build();
    }

    public static MasterProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(Pattern pattern, boolean includeSysTables) {
        MasterProtos.GetTableDescriptorsRequest.Builder builder = MasterProtos.GetTableDescriptorsRequest.newBuilder();
        if (pattern != null) {
            builder.setRegex(pattern.toString());
        }
        builder.setIncludeSysTables(includeSysTables);
        return builder.build();
    }

    public static MasterProtos.GetTableNamesRequest buildGetTableNamesRequest(Pattern pattern, boolean includeSysTables) {
        MasterProtos.GetTableNamesRequest.Builder builder = MasterProtos.GetTableNamesRequest.newBuilder();
        if (pattern != null) {
            builder.setRegex(pattern.toString());
        }
        builder.setIncludeSysTables(includeSysTables);
        return builder.build();
    }

    public static MasterProtos.GetTableStateRequest buildGetTableStateRequest(TableName tableName) {
        return MasterProtos.GetTableStateRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).build();
    }

    public static MasterProtos.SetTableStateInMetaRequest buildSetTableStateInMetaRequest(TableState state) {
        return MasterProtos.SetTableStateInMetaRequest.newBuilder().setTableState(state.convert()).setTableName(ProtobufUtil.toProtoTableName(state.getTableName())).build();
    }

    public static MasterProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(TableName tableName) {
        return MasterProtos.GetTableDescriptorsRequest.newBuilder().addTableNames(ProtobufUtil.toProtoTableName(tableName)).build();
    }

    public static MasterProtos.IsMasterRunningRequest buildIsMasterRunningRequest() {
        return MasterProtos.IsMasterRunningRequest.newBuilder().build();
    }

    public static MasterProtos.BalanceRequest buildBalanceRequest(boolean force) {
        return MasterProtos.BalanceRequest.newBuilder().setForce(force).build();
    }

    public static MasterProtos.SetBalancerRunningRequest buildSetBalancerRunningRequest(boolean on, boolean synchronous) {
        return MasterProtos.SetBalancerRunningRequest.newBuilder().setOn(on).setSynchronous(synchronous).build();
    }

    public static MasterProtos.IsBalancerEnabledRequest buildIsBalancerEnabledRequest() {
        return MasterProtos.IsBalancerEnabledRequest.newBuilder().build();
    }

    public static AdminProtos.ClearRegionBlockCacheRequest buildClearRegionBlockCacheRequest(List<RegionInfo> hris) {
        AdminProtos.ClearRegionBlockCacheRequest.Builder builder = AdminProtos.ClearRegionBlockCacheRequest.newBuilder();
        hris.forEach(hri -> builder.addRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, hri.getRegionName())));
        return builder.build();
    }

    public static MasterProtos.GetClusterStatusRequest buildGetClusterStatusRequest(EnumSet<ClusterMetrics.Option> options) {
        return MasterProtos.GetClusterStatusRequest.newBuilder().addAllOptions(ClusterMetricsBuilder.toOptions(options)).build();
    }

    public static MasterProtos.RunCatalogScanRequest buildCatalogScanRequest() {
        return CATALOG_SCAN_REQUEST;
    }

    public static MasterProtos.EnableCatalogJanitorRequest buildEnableCatalogJanitorRequest(boolean enable) {
        return MasterProtos.EnableCatalogJanitorRequest.newBuilder().setEnable(enable).build();
    }

    public static MasterProtos.IsCatalogJanitorEnabledRequest buildIsCatalogJanitorEnabledRequest() {
        return IS_CATALOG_JANITOR_ENABLED_REQUEST;
    }

    public static MasterProtos.RunCleanerChoreRequest buildRunCleanerChoreRequest() {
        return CLEANER_CHORE_REQUEST;
    }

    public static MasterProtos.SetCleanerChoreRunningRequest buildSetCleanerChoreRunningRequest(boolean on) {
        return MasterProtos.SetCleanerChoreRunningRequest.newBuilder().setOn(on).build();
    }

    public static MasterProtos.IsCleanerChoreEnabledRequest buildIsCleanerChoreEnabledRequest() {
        return IS_CLEANER_CHORE_ENABLED_REQUEST;
    }

    public static RegionServerStatusProtos.GetLastFlushedSequenceIdRequest buildGetLastFlushedSequenceIdRequest(byte[] regionName) {
        return RegionServerStatusProtos.GetLastFlushedSequenceIdRequest.newBuilder().setRegionName(UnsafeByteOperations.unsafeWrap((byte[])regionName)).build();
    }

    public static AdminProtos.OpenRegionRequest.RegionOpenInfo buildRegionOpenInfo(RegionInfo region, List<ServerName> favoredNodes, long openProcId) {
        AdminProtos.OpenRegionRequest.RegionOpenInfo.Builder builder = AdminProtos.OpenRegionRequest.RegionOpenInfo.newBuilder();
        builder.setRegion(ProtobufUtil.toRegionInfo(region));
        if (favoredNodes != null) {
            for (ServerName server : favoredNodes) {
                builder.addFavoredNodes(ProtobufUtil.toServerName(server));
            }
        }
        builder.setOpenProcId(openProcId);
        return builder.build();
    }

    public static MasterProtos.NormalizeRequest buildNormalizeRequest() {
        return MasterProtos.NormalizeRequest.newBuilder().build();
    }

    public static MasterProtos.IsNormalizerEnabledRequest buildIsNormalizerEnabledRequest() {
        return MasterProtos.IsNormalizerEnabledRequest.newBuilder().build();
    }

    public static MasterProtos.SetNormalizerRunningRequest buildSetNormalizerRunningRequest(boolean on) {
        return MasterProtos.SetNormalizerRunningRequest.newBuilder().setOn(on).build();
    }

    public static MasterProtos.IsSplitOrMergeEnabledRequest buildIsSplitOrMergeEnabledRequest(MasterSwitchType switchType) {
        MasterProtos.IsSplitOrMergeEnabledRequest.Builder builder = MasterProtos.IsSplitOrMergeEnabledRequest.newBuilder();
        builder.setSwitchType(RequestConverter.convert(switchType));
        return builder.build();
    }

    public static MasterProtos.SetSplitOrMergeEnabledRequest buildSetSplitOrMergeEnabledRequest(boolean enabled, boolean synchronous, MasterSwitchType ... switchTypes) {
        MasterProtos.SetSplitOrMergeEnabledRequest.Builder builder = MasterProtos.SetSplitOrMergeEnabledRequest.newBuilder();
        builder.setEnabled(enabled);
        builder.setSynchronous(synchronous);
        for (MasterSwitchType switchType : switchTypes) {
            builder.addSwitchTypes(RequestConverter.convert(switchType));
        }
        return builder.build();
    }

    private static MasterProtos.MasterSwitchType convert(MasterSwitchType switchType) {
        switch (switchType) {
            case SPLIT: {
                return MasterProtos.MasterSwitchType.SPLIT;
            }
            case MERGE: {
                return MasterProtos.MasterSwitchType.MERGE;
            }
        }
        throw new UnsupportedOperationException("Unsupport switch type:" + (Object)((Object)switchType));
    }

    public static ReplicationProtos.AddReplicationPeerRequest buildAddReplicationPeerRequest(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) {
        ReplicationProtos.AddReplicationPeerRequest.Builder builder = ReplicationProtos.AddReplicationPeerRequest.newBuilder();
        builder.setPeerId(peerId);
        builder.setPeerConfig(ReplicationPeerConfigUtil.convert(peerConfig));
        ReplicationProtos.ReplicationState.Builder stateBuilder = ReplicationProtos.ReplicationState.newBuilder();
        stateBuilder.setState(enabled ? ReplicationProtos.ReplicationState.State.ENABLED : ReplicationProtos.ReplicationState.State.DISABLED);
        builder.setPeerState(stateBuilder.build());
        return builder.build();
    }

    public static ReplicationProtos.RemoveReplicationPeerRequest buildRemoveReplicationPeerRequest(String peerId) {
        ReplicationProtos.RemoveReplicationPeerRequest.Builder builder = ReplicationProtos.RemoveReplicationPeerRequest.newBuilder();
        builder.setPeerId(peerId);
        return builder.build();
    }

    public static ReplicationProtos.EnableReplicationPeerRequest buildEnableReplicationPeerRequest(String peerId) {
        ReplicationProtos.EnableReplicationPeerRequest.Builder builder = ReplicationProtos.EnableReplicationPeerRequest.newBuilder();
        builder.setPeerId(peerId);
        return builder.build();
    }

    public static ReplicationProtos.DisableReplicationPeerRequest buildDisableReplicationPeerRequest(String peerId) {
        ReplicationProtos.DisableReplicationPeerRequest.Builder builder = ReplicationProtos.DisableReplicationPeerRequest.newBuilder();
        builder.setPeerId(peerId);
        return builder.build();
    }

    public static ReplicationProtos.GetReplicationPeerConfigRequest buildGetReplicationPeerConfigRequest(String peerId) {
        ReplicationProtos.GetReplicationPeerConfigRequest.Builder builder = ReplicationProtos.GetReplicationPeerConfigRequest.newBuilder();
        builder.setPeerId(peerId);
        return builder.build();
    }

    public static ReplicationProtos.UpdateReplicationPeerConfigRequest buildUpdateReplicationPeerConfigRequest(String peerId, ReplicationPeerConfig peerConfig) {
        ReplicationProtos.UpdateReplicationPeerConfigRequest.Builder builder = ReplicationProtos.UpdateReplicationPeerConfigRequest.newBuilder();
        builder.setPeerId(peerId);
        builder.setPeerConfig(ReplicationPeerConfigUtil.convert(peerConfig));
        return builder.build();
    }

    public static ReplicationProtos.ListReplicationPeersRequest buildListReplicationPeersRequest(Pattern pattern) {
        ReplicationProtos.ListReplicationPeersRequest.Builder builder = ReplicationProtos.ListReplicationPeersRequest.newBuilder();
        if (pattern != null) {
            builder.setRegex(pattern.toString());
        }
        return builder.build();
    }

    public static MasterProtos.CreateNamespaceRequest buildCreateNamespaceRequest(NamespaceDescriptor descriptor) {
        MasterProtos.CreateNamespaceRequest.Builder builder = MasterProtos.CreateNamespaceRequest.newBuilder();
        builder.setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor));
        return builder.build();
    }

    public static MasterProtos.ModifyNamespaceRequest buildModifyNamespaceRequest(NamespaceDescriptor descriptor) {
        MasterProtos.ModifyNamespaceRequest.Builder builder = MasterProtos.ModifyNamespaceRequest.newBuilder();
        builder.setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor));
        return builder.build();
    }

    public static MasterProtos.DeleteNamespaceRequest buildDeleteNamespaceRequest(String name) {
        MasterProtos.DeleteNamespaceRequest.Builder builder = MasterProtos.DeleteNamespaceRequest.newBuilder();
        builder.setNamespaceName(name);
        return builder.build();
    }

    public static MasterProtos.GetNamespaceDescriptorRequest buildGetNamespaceDescriptorRequest(String name) {
        MasterProtos.GetNamespaceDescriptorRequest.Builder builder = MasterProtos.GetNamespaceDescriptorRequest.newBuilder();
        builder.setNamespaceName(name);
        return builder.build();
    }

    public static AdminProtos.ClearCompactionQueuesRequest buildClearCompactionQueuesRequest(Set<String> queues) {
        AdminProtos.ClearCompactionQueuesRequest.Builder builder = AdminProtos.ClearCompactionQueuesRequest.newBuilder();
        for (String name : queues) {
            builder.addQueueName(name);
        }
        return builder.build();
    }

    public static MasterProtos.ClearDeadServersRequest buildClearDeadServersRequest(Collection<ServerName> deadServers) {
        MasterProtos.ClearDeadServersRequest.Builder builder = MasterProtos.ClearDeadServersRequest.newBuilder();
        for (ServerName server : deadServers) {
            builder.addServerName(ProtobufUtil.toServerName(server));
        }
        return builder.build();
    }

    public static QuotaProtos.GetSpaceQuotaRegionSizesRequest buildGetSpaceQuotaRegionSizesRequest() {
        return GET_SPACE_QUOTA_REGION_SIZES_REQUEST;
    }

    public static QuotaProtos.GetSpaceQuotaSnapshotsRequest buildGetSpaceQuotaSnapshotsRequest() {
        return GET_SPACE_QUOTA_SNAPSHOTS_REQUEST;
    }

    public static QuotaProtos.GetQuotaStatesRequest buildGetQuotaStatesRequest() {
        return GET_QUOTA_STATES_REQUEST;
    }

    public static MasterProtos.DecommissionRegionServersRequest buildDecommissionRegionServersRequest(List<ServerName> servers, boolean offload) {
        return MasterProtos.DecommissionRegionServersRequest.newBuilder().addAllServerName(RequestConverter.toProtoServerNames(servers)).setOffload(offload).build();
    }

    public static MasterProtos.RecommissionRegionServerRequest buildRecommissionRegionServerRequest(ServerName server, List<byte[]> encodedRegionNames) {
        MasterProtos.RecommissionRegionServerRequest.Builder builder = MasterProtos.RecommissionRegionServerRequest.newBuilder();
        if (encodedRegionNames != null) {
            for (byte[] name : encodedRegionNames) {
                builder.addRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, name));
            }
        }
        return builder.setServerName(ProtobufUtil.toServerName(server)).build();
    }

    private static List<HBaseProtos.ServerName> toProtoServerNames(List<ServerName> servers) {
        ArrayList<HBaseProtos.ServerName> pbServers = new ArrayList<HBaseProtos.ServerName>(servers.size());
        for (ServerName server : servers) {
            pbServers.add(ProtobufUtil.toServerName(server));
        }
        return pbServers;
    }

    public static MasterProtos.AssignsRequest toAssignRegionsRequest(List<String> encodedRegionNames, boolean override) {
        MasterProtos.AssignsRequest.Builder b = MasterProtos.AssignsRequest.newBuilder();
        return b.addAllRegion(RequestConverter.toEncodedRegionNameRegionSpecifiers(encodedRegionNames)).setOverride(override).build();
    }

    public static MasterProtos.UnassignsRequest toUnassignRegionsRequest(List<String> encodedRegionNames, boolean override) {
        MasterProtos.UnassignsRequest.Builder b = MasterProtos.UnassignsRequest.newBuilder();
        return b.addAllRegion(RequestConverter.toEncodedRegionNameRegionSpecifiers(encodedRegionNames)).setOverride(override).build();
    }

    public static MasterProtos.ScheduleServerCrashProcedureRequest toScheduleServerCrashProcedureRequest(List<ServerName> serverNames) {
        MasterProtos.ScheduleServerCrashProcedureRequest.Builder builder = MasterProtos.ScheduleServerCrashProcedureRequest.newBuilder();
        serverNames.stream().map(ProtobufUtil::toServerName).forEach(sn -> builder.addServerName(sn));
        return builder.build();
    }

    private static List<HBaseProtos.RegionSpecifier> toEncodedRegionNameRegionSpecifiers(List<String> encodedRegionNames) {
        return encodedRegionNames.stream().map(r -> RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, Bytes.toBytes((String)r))).collect(Collectors.toList());
    }
}

