/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hugegraph.iterator.CIter;
import org.apache.hugegraph.iterator.Metadatable;

public abstract class WrappedIterator<R>
implements CIter<R> {
    private static final Object NONE = new Object();
    protected R current = WrappedIterator.none();

    @Override
    public boolean hasNext() {
        if (this.current != WrappedIterator.none()) {
            return true;
        }
        return this.fetch();
    }

    @Override
    public R next() {
        if (this.current == WrappedIterator.none()) {
            this.fetch();
            if (this.current == WrappedIterator.none()) {
                throw new NoSuchElementException();
            }
        }
        R current = this.current;
        this.current = WrappedIterator.none();
        return current;
    }

    @Override
    public void remove() {
        Iterator<?> iterator = this.originIterator();
        if (iterator == null) {
            throw new NoSuchElementException("The origin iterator can't be null for removing");
        }
        iterator.remove();
    }

    @Override
    public void close() throws Exception {
        Iterator<?> iterator = this.originIterator();
        if (iterator instanceof AutoCloseable) {
            ((AutoCloseable)((Object)iterator)).close();
        }
    }

    @Override
    public Object metadata(String meta, Object ... args) {
        Iterator<?> iterator = this.originIterator();
        if (iterator instanceof Metadatable) {
            return ((Metadatable)((Object)iterator)).metadata(meta, args);
        }
        throw new IllegalStateException("Original iterator is not Metadatable");
    }

    protected static final <R> R none() {
        return (R)NONE;
    }

    public static void close(Iterator<?> iterator) {
        if (iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)iterator)).close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to close iterator");
            }
        }
    }

    protected abstract Iterator<?> originIterator();

    protected abstract boolean fetch();
}

