/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context;

import org.simpleflatmapper.util.Predicate;

public class KeyAndPredicate<S, K>
implements Predicate<S> {
    public final K key;
    public final Predicate<? super S> predicate;

    public KeyAndPredicate(K key, Predicate<? super S> predicate) {
        this.key = key;
        this.predicate = predicate;
    }

    public boolean test(S s) {
        return this.predicate == null ? true : this.predicate.test(s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyAndPredicate that = (KeyAndPredicate)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.predicate != null ? this.predicate.equals(that.predicate) : that.predicate == null;
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.predicate != null ? this.predicate.hashCode() : 0);
        return result;
    }

    public KeyAndPredicate<S, K> mergeWith(KeyAndPredicate<S, K> keyAndPredicate) {
        if (!this.key.equals(keyAndPredicate.key)) {
            throw new IllegalArgumentException();
        }
        if (this.predicate == null || keyAndPredicate.predicate == null) {
            return this;
        }
        if (this.predicate.equals(keyAndPredicate.predicate)) {
            return this;
        }
        return new KeyAndPredicate(this.key, new OrPredicate(this.predicate, keyAndPredicate.predicate));
    }

    private static class OrPredicate<S>
    implements Predicate<S> {
        private final Predicate<? super S> p1;
        private final Predicate<? super S> p2;

        private OrPredicate(Predicate<? super S> p1, Predicate<? super S> p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public boolean test(S s) {
            return this.p1.test(s) || this.p2.test(s);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrPredicate that = (OrPredicate)o;
            if (this.p1 != null ? !this.p1.equals(that.p1) : that.p1 != null) {
                return false;
            }
            return this.p2 != null ? this.p2.equals(that.p2) : that.p2 == null;
        }

        public int hashCode() {
            int result = this.p1 != null ? this.p1.hashCode() : 0;
            result = 31 * result + (this.p2 != null ? this.p2.hashCode() : 0);
            return result;
        }
    }
}

