/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.Prediction;
import org.apache.hugegraph.util.E;

public class ResourceAllocationAPI
extends TraversersAPI {
    private static final String RESOURCE_ALLOCATION = "resource_allocation";

    public ResourceAllocationAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return "resourceallocation";
    }

    public Prediction get(Object vertexId, Object otherId, Direction direction, String label, long degree) {
        this.client.checkApiVersion("0.67", RESOURCE_ALLOCATION);
        String vertex = GraphAPI.formatVertexId(vertexId, false);
        String other = GraphAPI.formatVertexId(otherId, false);
        ResourceAllocationAPI.checkDegree(degree);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vertex", vertex);
        params.put("other", other);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_degree", degree);
        RestResult result = this.client.get(this.path(), params);
        Prediction res = (Prediction)result.readObject(Prediction.class);
        Map resourceAllocation = (Map)result.readObject(Map.class);
        E.checkState((res.getResourceAllocation() != null ? 1 : 0) != 0, (String)"The result doesn't have key '%s'", (Object[])new Object[]{RESOURCE_ALLOCATION});
        return res;
    }
}

