/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.traverser.Steps;
import org.apache.hugegraph.util.E;

public class KneighborRequest {
    @JsonProperty(value="source")
    private Object source = null;
    @JsonProperty(value="steps")
    public Steps steps = null;
    @JsonProperty(value="max_depth")
    public int maxDepth = 5000;
    @JsonProperty(value="count_only")
    public boolean countOnly = false;
    @JsonProperty(value="limit")
    public long limit = 10L;
    @JsonProperty(value="with_vertex")
    public boolean withVertex = false;
    @JsonProperty(value="with_path")
    public boolean withPath = false;
    @JsonProperty(value="with_edge")
    public boolean withEdge = false;

    private KneighborRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("KneighborRequest{source=%s,steps=%s,maxDepth=%scountOnly=%s,limit=%s,withVertex=%s,withPath=%s,withEdge=%s}", this.source, this.steps, this.maxDepth, this.countOnly, this.limit, this.withVertex, this.withPath, this.withEdge);
    }

    public static class Builder {
        private final KneighborRequest request = new KneighborRequest();
        private Steps.Builder stepsBuilder = Steps.builder();

        private Builder() {
        }

        public Builder source(Object source) {
            E.checkNotNull((Object)source, (String)"source");
            this.request.source = source;
            return this;
        }

        public Steps.Builder steps() {
            Steps.Builder builder;
            this.stepsBuilder = builder = Steps.builder();
            return builder;
        }

        public Builder maxDepth(int maxDepth) {
            TraversersAPI.checkPositive(maxDepth, "max depth");
            this.request.maxDepth = maxDepth;
            return this;
        }

        public Builder countOnly(boolean countOnly) {
            this.request.countOnly = countOnly;
            return this;
        }

        public Builder limit(long limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public Builder withEdge(boolean withEdge) {
            this.request.withEdge = withEdge;
            return this;
        }

        public Builder withPath(boolean withPath) {
            this.request.withPath = withPath;
            return this;
        }

        public KneighborRequest build() {
            E.checkNotNull((Object)this.request.source, (String)"The source can't be null");
            this.request.steps = this.stepsBuilder.build();
            E.checkNotNull((Object)this.request.steps, (String)"steps");
            TraversersAPI.checkPositive(this.request.maxDepth, "max depth");
            TraversersAPI.checkLimit(this.request.limit);
            if (this.request.countOnly) {
                E.checkArgument((!this.request.withVertex && !this.request.withPath && !this.request.withEdge ? 1 : 0) != 0, (String)"Can't return vertex or path or edge when count only is true", (Object[])new Object[0]);
            }
            return this.request;
        }
    }
}

