/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.space;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GraphSpace {
    @JsonProperty(value="store_group")
    public int storeGroup;
    @JsonProperty(value="storage_limit")
    public int storageLimit;
    @JsonProperty(value="oltp_namespace")
    public String oltpNamespace;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="nickname")
    private String nickname;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="cpu_limit")
    private int cpuLimit;
    @JsonProperty(value="memory_limit")
    private int memoryLimit;
    @JsonProperty(value="compute_cpu_limit")
    private int computeCpuLimit;
    @JsonProperty(value="compute_memory_limit")
    private int computeMemoryLimit;
    @JsonProperty(value="max_graph_number")
    private int maxGraphNumber;
    @JsonProperty(value="max_role_number")
    private int maxRoleNumber;
    @JsonProperty(value="operator_image_path")
    private String operatorImagePath;
    @JsonProperty(value="internal_algorithm_image_url")
    private String internalAlgorithmImageUrl;
    @JsonProperty(value="olap_namespace")
    private String olapNamespace;
    @Deprecated
    @JsonProperty(value="storage_namespace")
    private String storageNamespace;
    @JsonProperty(value="cpu_used")
    private int cpuUsed;
    @JsonProperty(value="memory_used")
    private int memoryUsed;
    @JsonProperty(value="storage_used")
    private int storageUsed;
    @JsonProperty(value="storage_percent")
    private double storagePercent;
    @JsonProperty(value="graph_number_used")
    private int graphNumberUsed;
    @JsonProperty(value="role_number_used")
    private int roleNumberUsed;
    @JsonProperty(value="auth")
    private boolean auth = false;
    @JsonProperty(value="dp_username")
    private String dpUserName;
    @JsonProperty(value="dp_password")
    private String dpPassWord;
    @JsonIgnore
    private String createTime;
    @JsonIgnore
    private String updateTime;
    @JsonProperty(value="configs")
    private Map<String, Object> configs = new HashMap<String, Object>();

    public GraphSpace() {
    }

    public GraphSpace(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GraphSpace setName(String name) {
        this.name = name;
        return this;
    }

    public String getNickname() {
        return this.nickname;
    }

    public GraphSpace setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public String getDpUserName() {
        return this.dpUserName;
    }

    public void setDpUserName(String dpUserName) {
        this.dpUserName = dpUserName;
    }

    public String getDpPassWord() {
        return this.dpPassWord;
    }

    public void setDpPassWord(String dpPassWord) {
        this.dpPassWord = dpPassWord;
    }

    public String getDescription() {
        return this.description;
    }

    public GraphSpace setDescription(String description) {
        this.description = description;
        return this;
    }

    public int getCpuLimit() {
        return this.cpuLimit;
    }

    public GraphSpace setCpuLimit(int cpuLimit) {
        this.cpuLimit = cpuLimit;
        return this;
    }

    public int getMemoryLimit() {
        return this.memoryLimit;
    }

    public GraphSpace setMemoryLimit(int memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    public int getStorageLimit() {
        return this.storageLimit;
    }

    public GraphSpace setStorageLimit(int storageLimit) {
        this.storageLimit = storageLimit;
        return this;
    }

    public int getMaxGraphNumber() {
        return this.maxGraphNumber;
    }

    public GraphSpace setMaxGraphNumber(int maxGraphNumber) {
        this.maxGraphNumber = maxGraphNumber;
        return this;
    }

    public int getMaxRoleNumber() {
        return this.maxRoleNumber;
    }

    public GraphSpace setMaxRoleNumber(int maxRoleNumber) {
        this.maxRoleNumber = maxRoleNumber;
        return this;
    }

    public String getOltpNamespace() {
        return this.oltpNamespace;
    }

    public GraphSpace setOltpNamespace(String oltpNamespace) {
        this.oltpNamespace = oltpNamespace;
        return this;
    }

    public String getOlapNamespace() {
        return this.olapNamespace;
    }

    public GraphSpace setOlapNamespace(String olapNamespace) {
        this.olapNamespace = olapNamespace;
        return this;
    }

    public String getOperatorImagePath() {
        return this.operatorImagePath;
    }

    public void setOperatorImagePath(String operatorImagePath) {
        this.operatorImagePath = operatorImagePath;
    }

    public String getInternalAlgorithmImageUrl() {
        return this.internalAlgorithmImageUrl;
    }

    public void setInternalAlgorithmImageUrl(String internalAlgorithmImageUrl) {
        this.internalAlgorithmImageUrl = internalAlgorithmImageUrl;
    }

    public String getStorageNamespace() {
        return this.storageNamespace;
    }

    public GraphSpace setStorageNamespace(String storageNamespace) {
        this.storageNamespace = storageNamespace;
        return this;
    }

    public int getCpuUsed() {
        return this.cpuUsed;
    }

    public GraphSpace setCpuUsed(int cpuUsed) {
        this.cpuUsed = cpuUsed;
        return this;
    }

    public int getMemoryUsed() {
        return this.memoryUsed;
    }

    public GraphSpace setMemoryUsed(int memoryUsed) {
        this.memoryUsed = memoryUsed;
        return this;
    }

    public int getComputeCpuLimit() {
        return this.computeCpuLimit;
    }

    public void setComputeCpuLimit(int computeCpuLimit) {
        this.computeCpuLimit = computeCpuLimit;
    }

    public int getComputeMemoryLimit() {
        return this.computeMemoryLimit;
    }

    public void setComputeMemoryLimit(int computeMemoryLimit) {
        this.computeMemoryLimit = computeMemoryLimit;
    }

    public int getStorageUsed() {
        return this.storageUsed;
    }

    public GraphSpace setStorageUsed(int storageUsed) {
        this.storageUsed = storageUsed;
        return this;
    }

    public double getStoragePercent() {
        return this.storagePercent;
    }

    public GraphSpace setStoragePercent(double storagePercent) {
        this.storagePercent = storagePercent;
        return this;
    }

    public int getGraphNumberUsed() {
        return this.graphNumberUsed;
    }

    public GraphSpace setGraphNumberUsed(int graphNumberUsed) {
        this.graphNumberUsed = graphNumberUsed;
        return this;
    }

    public int getRoleNumberUsed() {
        return this.roleNumberUsed;
    }

    public GraphSpace setRoleNumberUsed(int roleNumberUsed) {
        this.roleNumberUsed = roleNumberUsed;
        return this;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public Map<String, Object> getConfigs() {
        return this.configs;
    }

    public GraphSpace setConfigs(Map<String, Object> configs) {
        this.configs = configs;
        return this;
    }

    public Object convertReq() {
        return new GraphSpaceReq(this);
    }

    @JsonIgnoreProperties(value={"cpu_used", "memory_used", "storage_used", "storage_percent", "graph_number_used", "role_number_used", "create_time", "update_time"})
    public static class GraphSpaceReq
    extends GraphSpace {
        public GraphSpaceReq(GraphSpace graphSpace) {
            this.setName(graphSpace.getName());
            this.setNickname(graphSpace.getNickname());
            this.setAuth(graphSpace.isAuth());
            this.setDescription(graphSpace.getDescription());
            this.setCpuLimit(graphSpace.getCpuLimit());
            this.setMemoryLimit(graphSpace.getMemoryLimit());
            this.setComputeCpuLimit(graphSpace.getComputeCpuLimit());
            this.setComputeMemoryLimit(graphSpace.getComputeMemoryLimit());
            this.setOperatorImagePath(graphSpace.getOperatorImagePath());
            this.setInternalAlgorithmImageUrl(graphSpace.getInternalAlgorithmImageUrl());
            this.setStorageLimit(graphSpace.getStorageLimit());
            this.setMaxGraphNumber(graphSpace.getMaxGraphNumber());
            this.setMaxRoleNumber(graphSpace.getMaxRoleNumber());
            this.setOltpNamespace(graphSpace.getOltpNamespace());
            this.setOlapNamespace(graphSpace.getOlapNamespace());
        }
    }
}

