/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.VEStep;

public class VESteps {
    @JsonProperty(value="direction")
    public Direction direction = Direction.BOTH;
    @JsonAlias(value={"degree"})
    @JsonProperty(value="max_degree")
    public long maxDegree = 10000L;
    @JsonProperty(value="skip_degree")
    public long skipDegree = 100000L;
    @JsonProperty(value="vertex_steps")
    public List<VEStep> vSteps = new ArrayList<VEStep>();
    @JsonProperty(value="edge_steps")
    public List<VEStep> eSteps = new ArrayList<VEStep>();

    protected VESteps() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("Steps{direction=%s,maxDegree=%s,skipDegree=%s,vSteps=%s,eSteps=%s}", new Object[]{this.direction, this.maxDegree, this.skipDegree, this.vSteps, this.eSteps});
    }

    public static class Builder {
        protected VESteps steps = new VESteps();

        private Builder() {
        }

        public Builder direction(Direction direction) {
            this.steps.direction = direction;
            return this;
        }

        public Builder vSteps(List<VEStep> vSteps) {
            this.steps.vSteps = vSteps;
            return this;
        }

        public Builder addVStep(String label, Map<String, Object> properties) {
            VEStep vStep = VEStep.builder().label(label).properties(properties).build();
            this.steps.vSteps.add(vStep);
            return this;
        }

        public Builder addVStep(String label) {
            return this.addVStep(label, Collections.emptyMap());
        }

        public Builder eSteps(List<VEStep> eSteps) {
            this.steps.eSteps = eSteps;
            return this;
        }

        public Builder addEStep(String label, Map<String, Object> properties) {
            VEStep eStep = VEStep.builder().label(label).properties(properties).build();
            this.steps.eSteps.add(eStep);
            return this;
        }

        public Builder addEStep(String label) {
            return this.addEStep(label, Collections.emptyMap());
        }

        public Builder degree(long degree) {
            TraversersAPI.checkDegree(degree);
            this.steps.maxDegree = degree;
            return this;
        }

        public Builder skipDegree(long skipDegree) {
            TraversersAPI.checkSkipDegree(skipDegree, this.steps.maxDegree, -1L);
            this.steps.skipDegree = skipDegree;
            return this;
        }

        public VESteps build() {
            TraversersAPI.checkDegree(this.steps.maxDegree);
            TraversersAPI.checkSkipDegree(this.steps.skipDegree, this.steps.maxDegree, -1L);
            return this.steps;
        }
    }
}

