/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.constant.Direction;

public class Steps {
    @JsonProperty(value="direction")
    protected Direction direction = Direction.BOTH;
    @JsonProperty(value="edge_steps")
    public List<StepEntity> eSteps = new ArrayList<StepEntity>();
    @JsonProperty(value="vertex_steps")
    public List<StepEntity> vSteps = new ArrayList<StepEntity>();
    @JsonProperty(value="max_degree")
    protected long maxDegree = 10000L;
    @JsonProperty(value="skip_degree")
    protected long skipDegree = 100000L;

    protected Steps() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("Steps{direction=%s,eSteps=%s,vSteps=%s,maxDegree=%s,skipDegree=%s}", new Object[]{this.direction, this.eSteps, this.vSteps, this.maxDegree, this.skipDegree});
    }

    public static class StepEntity {
        @JsonProperty(value="label")
        public String label;
        @JsonProperty(value="properties")
        public Map<String, Object> properties;

        public StepEntity() {
        }

        public StepEntity(String label) {
            this.label = label;
        }

        public StepEntity(String label, Map<String, Object> properties) {
            this.label = label;
            this.properties = properties;
        }

        public String toString() {
            return String.format("StepEntity{label=%s,properties=%s}", this.label, this.properties);
        }
    }

    public static class Builder {
        protected Steps step = new Steps();

        private Builder() {
        }

        public Builder direction(Direction direction) {
            this.step.direction = direction;
            return this;
        }

        public Builder edgeSteps(List<StepEntity> eSteps) {
            this.step.eSteps = eSteps;
            return this;
        }

        public Builder edgeSteps(StepEntity stepEntity) {
            this.step.eSteps.add(stepEntity);
            return this;
        }

        public Builder vertexSteps(List<StepEntity> vSteps) {
            this.step.vSteps = vSteps;
            return this;
        }

        public Builder vertexSteps(StepEntity stepEntity) {
            this.step.vSteps.add(stepEntity);
            return this;
        }

        public Builder degree(long degree) {
            TraversersAPI.checkDegree(degree);
            this.step.maxDegree = degree;
            return this;
        }

        public Builder skipDegree(long skipDegree) {
            TraversersAPI.checkSkipDegree(skipDegree, this.step.maxDegree, -1L);
            this.step.skipDegree = skipDegree;
            return this;
        }

        public Steps build() {
            TraversersAPI.checkDegree(this.step.maxDegree);
            TraversersAPI.checkSkipDegree(this.step.skipDegree, this.step.maxDegree, -1L);
            return this.step;
        }
    }
}

