/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.space;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OLTPService {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="deployment_type")
    private DepleymentType depleymentType;
    @JsonProperty(value="type")
    private String type = "OLTP";
    @JsonProperty(value="count")
    private int count = 1;
    @JsonProperty(value="running")
    private int running;
    @JsonProperty(value="cpu_limit")
    private int cpuLimit = 1;
    @JsonProperty(value="memory_limit")
    private int memoryLimit = 4;
    @JsonProperty(value="storage_limit")
    private int storageLimit = 100;
    @JsonProperty(value="route_type")
    private String routeType = null;
    @JsonProperty(value="port")
    private int port = 0;
    @JsonProperty(value="create_time")
    private String createTime;
    @JsonProperty(value="update_time")
    private String updateTime;
    @JsonProperty(value="urls")
    private List<String> urls = new ArrayList<String>();
    @JsonProperty(value="configs")
    private Map<String, Object> configs = new HashMap<String, Object>();
    @JsonProperty
    private ServiceStatus status = ServiceStatus.UNKNOWN;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DepleymentType getDepleymentType() {
        return this.depleymentType;
    }

    public void setDepleymentType(DepleymentType depleymentType) {
        this.depleymentType = depleymentType;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getRunning() {
        return this.running;
    }

    public void setRunning(int running) {
        this.running = running;
    }

    public int getCpuLimit() {
        return this.cpuLimit;
    }

    public void setCpuLimit(int cpuLimit) {
        this.cpuLimit = cpuLimit;
    }

    public int getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(int memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public int getStorageLimit() {
        return this.storageLimit;
    }

    public void setStorageLimit(int storageLimit) {
        this.storageLimit = storageLimit;
    }

    public String getRouteType() {
        return this.routeType;
    }

    public void setRouteType(String routeType) {
        this.routeType = routeType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public Map<String, Object> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, Object> configs) {
        this.configs = configs;
    }

    public ServiceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServiceStatus status) {
        this.status = status;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public boolean checkIsK8s() {
        return DepleymentType.K8S.equals((Object)this.depleymentType);
    }

    @JsonIgnoreProperties(value={"configs", "create_time", "update_time", "running", "status"}, ignoreUnknown=true)
    public static class OLTPServiceReq
    extends OLTPService {
        public static OLTPServiceReq fromBase(OLTPService service) {
            OLTPServiceReq req = new OLTPServiceReq();
            req.setName(service.name);
            req.setDescription(service.description);
            req.setDepleymentType(service.depleymentType);
            req.setType(service.type);
            req.setCount(service.count);
            req.setCpuLimit(service.cpuLimit);
            req.setMemoryLimit(service.memoryLimit);
            req.setStorageLimit(service.storageLimit);
            req.setRouteType(service.routeType);
            req.setPort(service.port);
            req.setUrls(service.urls);
            return req;
        }
    }

    public static enum ServiceStatus {
        UNKNOWN,
        STARTING,
        RUNNING,
        STOPPED;

    }

    public static enum DepleymentType {
        K8S,
        MANUAL;

    }
}

