/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.UpdateStrategy;
import org.apache.hugegraph.util.E;

public class BatchEdgeRequest {
    @JsonProperty(value="edges")
    private List<Edge> edges = null;
    @JsonProperty(value="update_strategies")
    private Map<String, UpdateStrategy> updateStrategies = null;
    @JsonProperty(value="check_vertex")
    private boolean checkVertex = false;
    @JsonProperty(value="create_if_not_exist")
    private boolean createIfNotExist = true;

    public static Builder createBuilder() {
        return new Builder();
    }

    public String toString() {
        return String.format("BatchEdgeRequest{edges=%s,updateStrategies=%s,checkVertex=%s,createIfNotExist=%s}", this.edges, this.updateStrategies, this.checkVertex, this.createIfNotExist);
    }

    public static class Builder {
        private final BatchEdgeRequest req = new BatchEdgeRequest();

        public Builder edges(List<Edge> edges) {
            this.req.edges = edges;
            return this;
        }

        public Builder updatingStrategies(Map<String, UpdateStrategy> map) {
            this.req.updateStrategies = new HashMap<String, UpdateStrategy>(map);
            return this;
        }

        public Builder updatingStrategy(String property, UpdateStrategy strategy) {
            this.req.updateStrategies.put(property, strategy);
            return this;
        }

        public Builder checkVertex(boolean checkVertex) {
            this.req.checkVertex = checkVertex;
            return this;
        }

        public Builder createIfNotExist(boolean createIfNotExist) {
            this.req.createIfNotExist = createIfNotExist;
            return this;
        }

        public BatchEdgeRequest build() {
            E.checkArgumentNotNull((Object)this.req, (String)"BatchEdgeRequest can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.req.edges, (String)"Parameter 'edges' can't be null", (Object[])new Object[0]);
            E.checkArgument((this.req.updateStrategies != null && !this.req.updateStrategies.isEmpty() ? 1 : 0) != 0, (String)"Parameter 'update_strategies' can't be empty", (Object[])new Object[0]);
            E.checkArgument((boolean)this.req.createIfNotExist, (String)"Parameter 'create_if_not_exist' dose not support false now", (Object[])new Object[0]);
            return this.req;
        }
    }
}

