/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.base;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.hugegraph.base.ToolClient;
import org.apache.hugegraph.rest.SerializeException;

public class ToolManager {
    protected final ToolClient client;
    private final String type;

    public ToolManager(ToolClient.ConnectionInfo info, String type) {
        this.client = new ToolClient(info);
        this.type = type;
    }

    protected String type() {
        return this.type;
    }

    protected String graph() {
        return this.client.graph().graph();
    }

    protected <T> List<T> readList(String key, Class<T> clazz, String content) {
        ObjectMapper mapper = this.client.mapper();
        try {
            JsonNode root = mapper.readTree(content);
            JsonNode element = root.get(key);
            if (element == null) {
                throw new SerializeException("Can't find value of the key: %s in json.", new Object[]{key});
            }
            JavaType t = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
            return (List)mapper.readValue(element.toString(), t);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to deserialize %s", (Throwable)e, new Object[]{content});
        }
    }

    public void close() {
        this.client.close();
    }
}

