/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.load;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.common.Constant;
import org.apache.hugegraph.common.Response;
import org.apache.hugegraph.entity.enums.JobStatus;
import org.apache.hugegraph.entity.enums.LoadStatus;
import org.apache.hugegraph.entity.load.FileMapping;
import org.apache.hugegraph.entity.load.JobManager;
import org.apache.hugegraph.entity.load.JobManagerReasonResult;
import org.apache.hugegraph.entity.load.LoadTask;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.service.load.FileMappingService;
import org.apache.hugegraph.service.load.JobManagerService;
import org.apache.hugegraph.service.load.LoadTaskService;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/job-manager"})
public class JobManagerController {
    private static final Logger log = LogManager.getLogger(JobManagerController.class);
    private static final int LIMIT = 500;
    private final JobManagerService service;
    @Autowired
    private FileMappingService fmService;
    @Autowired
    private LoadTaskService taskService;

    @Autowired
    public JobManagerController(JobManagerService service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    public JobManager create(@PathVariable(value="connId") int connId, @RequestBody JobManager entity) {
        JobManagerService jobManagerService = this.service;
        synchronized (jobManagerService) {
            Ex.check(entity.getJobName().length() <= 48, "job.manager.job-name.reached-limit", new Object[0]);
            Ex.check(entity.getJobName() != null, () -> Constant.COMMON_NAME_PATTERN.matcher(entity.getJobName()).matches(), "job.manager.job-name.unmatch-regex", new Object[0]);
            Ex.check(entity.getJobRemarks().length() <= 200, "job.manager.job-remarks.reached-limit", new Object[0]);
            Ex.check(!StringUtils.isEmpty((CharSequence)entity.getJobRemarks()), () -> Constant.COMMON_REMARK_PATTERN.matcher(entity.getJobRemarks()).matches(), "job.manager.job-remarks.unmatch-regex", new Object[0]);
            Ex.check(this.service.count() < 500, "job.manager.reached-limit", 500);
            if (this.service.getTask(entity.getJobName(), connId) != null) {
                throw new InternalException("job.manager.job-name.repeated", new Object[0]);
            }
            entity.setConnId(connId);
            entity.setJobStatus(JobStatus.DEFAULT);
            entity.setJobDuration(0L);
            entity.setJobSize(0L);
            entity.setUpdateTime(HubbleUtil.nowDate());
            entity.setCreateTime(HubbleUtil.nowDate());
            this.service.save(entity);
        }
        return entity;
    }

    @DeleteMapping(value={"{id}"})
    public void delete(@PathVariable(value="id") int id) {
        JobManager task = this.service.get(id);
        if (task == null) {
            throw new ExternalException("job.manager.not-exist.id", id);
        }
        this.service.remove(id);
    }

    @GetMapping(value={"{id}"})
    public JobManager get(@PathVariable(value="id") int id) {
        JobManager job = this.service.get(id);
        if (job == null) {
            throw new ExternalException("job.manager.not-exist.id", id);
        }
        return job;
    }

    @GetMapping(value={"ids"})
    public List<JobManager> list(@PathVariable(value="connId") int connId, @RequestParam(value="job_ids") List<Integer> jobIds) {
        return this.service.list(connId, jobIds);
    }

    @GetMapping
    public IPage<JobManager> list(@PathVariable(value="connId") int connId, @RequestParam(name="page_no", required=false, defaultValue="1") int pageNo, @RequestParam(name="page_size", required=false, defaultValue="10") int pageSize, @RequestParam(name="content", required=false, defaultValue="") String content) {
        return this.service.list(connId, pageNo, pageSize, content);
    }

    @PutMapping(value={"{id}"})
    public JobManager update(@PathVariable(value="connId") int connId, @PathVariable(value="id") int id, @RequestBody JobManager newEntity) {
        Ex.check(newEntity.getJobName().length() <= 48, "job.manager.job-name.reached-limit", new Object[0]);
        Ex.check(newEntity.getJobName() != null, () -> Constant.COMMON_NAME_PATTERN.matcher(newEntity.getJobName()).matches(), "job.manager.job-name.unmatch-regex", new Object[0]);
        Ex.check(!StringUtils.isEmpty((CharSequence)newEntity.getJobRemarks()), () -> Constant.COMMON_REMARK_PATTERN.matcher(newEntity.getJobRemarks()).matches(), "job.manager.job-remarks.unmatch-regex", new Object[0]);
        JobManager entity = this.service.get(id);
        if (entity == null) {
            throw new ExternalException("job-manager.not-exist.id", id);
        }
        if (!newEntity.getJobName().equals(entity.getJobName()) && this.service.getTask(newEntity.getJobName(), connId) != null) {
            throw new InternalException("job.manager.job-name.repeated", new Object[0]);
        }
        entity.setJobName(newEntity.getJobName());
        entity.setJobRemarks(newEntity.getJobRemarks());
        this.service.update(entity);
        return entity;
    }

    @GetMapping(value={"{id}/reason"})
    public Response reason(@PathVariable(value="connId") int connId, @PathVariable(value="id") int id) {
        JobManager job = this.service.get(id);
        if (job == null) {
            throw new ExternalException("job.manager.not-exist.id", id);
        }
        List<LoadTask> tasks = this.taskService.batchTasks(job.getId());
        ArrayList reasonResults = new ArrayList();
        tasks.forEach(task -> {
            JobManagerReasonResult reasonResult = new JobManagerReasonResult();
            int fileId = task.getFileId();
            String reason = "";
            if (task.getStatus() == LoadStatus.FAILED) {
                FileMapping mapping = this.fmService.get(fileId);
                reason = this.taskService.readLoadFailedReason(mapping);
            }
            reasonResult.setTaskId(task.getJobId());
            reasonResult.setFileId(task.getFileId());
            reasonResult.setFileName(task.getFileName());
            reasonResult.setReason(reason);
            reasonResults.add(reasonResult);
        });
        return Response.builder().status(200).data(reasonResults).build();
    }
}

