/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class UniqueIndexMap<T>
implements Serializable {
    private static final long serialVersionUID = -1145635738654002342L;
    ConcurrentHashMap<T, Integer> mForwardMap = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, T> mReverseMap = new ConcurrentHashMap();
    AtomicInteger mIndex = new AtomicInteger(0);

    int map(T parameter) {
        Integer ret = this.mForwardMap.get(parameter);
        if (ret != null) {
            return ret;
        }
        int nexti = this.mIndex.incrementAndGet();
        assert (nexti < Short.MAX_VALUE);
        this.mForwardMap.put(parameter, nexti);
        this.mReverseMap.put(nexti, parameter);
        return nexti;
    }

    T unmap(int leni) {
        Integer len = leni;
        assert (this.mReverseMap.containsKey(len));
        return this.mReverseMap.get(len);
    }
}

