/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordIterator;

public class ApplyDeletionFileRecordIterator
implements FileRecordIterator<InternalRow> {
    private final FileRecordIterator<InternalRow> iterator;
    private final DeletionVector deletionVector;

    public ApplyDeletionFileRecordIterator(FileRecordIterator<InternalRow> iterator2, DeletionVector deletionVector) {
        this.iterator = iterator2;
        this.deletionVector = deletionVector;
    }

    public FileRecordIterator<InternalRow> iterator() {
        return this.iterator;
    }

    public DeletionVector deletionVector() {
        return this.deletionVector;
    }

    @Override
    public long returnedPosition() {
        return this.iterator.returnedPosition();
    }

    @Override
    public Path filePath() {
        return this.iterator.filePath();
    }

    @Override
    @Nullable
    public InternalRow next() throws IOException {
        InternalRow next;
        do {
            if ((next = (InternalRow)this.iterator.next()) != null) continue;
            return null;
        } while (this.deletionVector.isDeleted(this.returnedPosition()));
        return next;
    }

    @Override
    public void releaseBatch() {
        this.iterator.releaseBatch();
    }
}

