/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.fluss.fs.shaded.hadoop3.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.JsonSerialization;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class IOStatisticsSnapshot
implements IOStatistics,
Serializable,
IOStatisticsAggregator {
    private static final long serialVersionUID = -1762522703841538084L;
    private static final Class[] DESERIALIZATION_CLASSES = new Class[]{IOStatisticsSnapshot.class, TreeMap.class, Long.class, MeanStatistic.class};
    @JsonProperty
    private transient Map<String, Long> counters;
    @JsonProperty
    private transient Map<String, Long> gauges;
    @JsonProperty
    private transient Map<String, Long> minimums;
    @JsonProperty
    private transient Map<String, Long> maximums;
    @JsonProperty(value="meanstatistics")
    private transient Map<String, MeanStatistic> meanStatistics;

    public IOStatisticsSnapshot() {
        this.createMaps();
    }

    public IOStatisticsSnapshot(IOStatistics source2) {
        if (source2 != null) {
            this.snapshot(source2);
        } else {
            this.createMaps();
        }
    }

    private synchronized void createMaps() {
        this.counters = new ConcurrentHashMap<String, Long>();
        this.gauges = new ConcurrentHashMap<String, Long>();
        this.minimums = new ConcurrentHashMap<String, Long>();
        this.maximums = new ConcurrentHashMap<String, Long>();
        this.meanStatistics = new ConcurrentHashMap<String, MeanStatistic>();
    }

    public synchronized void clear() {
        this.counters.clear();
        this.gauges.clear();
        this.minimums.clear();
        this.maximums.clear();
        this.meanStatistics.clear();
    }

    public synchronized void snapshot(IOStatistics source2) {
        Preconditions.checkNotNull(source2);
        this.counters = IOStatisticsBinding.snapshotMap(source2.counters());
        this.gauges = IOStatisticsBinding.snapshotMap(source2.gauges());
        this.minimums = IOStatisticsBinding.snapshotMap(source2.minimums());
        this.maximums = IOStatisticsBinding.snapshotMap(source2.maximums());
        this.meanStatistics = IOStatisticsBinding.snapshotMap(source2.meanStatistics(), MeanStatistic::copy);
    }

    @Override
    public synchronized boolean aggregate(@Nullable IOStatistics source2) {
        if (source2 == null) {
            return false;
        }
        IOStatisticsBinding.aggregateMaps(this.counters, source2.counters(), IOStatisticsBinding::aggregateCounters, IOStatisticsBinding::passthroughFn);
        IOStatisticsBinding.aggregateMaps(this.gauges, source2.gauges(), IOStatisticsBinding::aggregateGauges, IOStatisticsBinding::passthroughFn);
        IOStatisticsBinding.aggregateMaps(this.minimums, source2.minimums(), IOStatisticsBinding::aggregateMinimums, IOStatisticsBinding::passthroughFn);
        IOStatisticsBinding.aggregateMaps(this.maximums, source2.maximums(), IOStatisticsBinding::aggregateMaximums, IOStatisticsBinding::passthroughFn);
        IOStatisticsBinding.aggregateMaps(this.meanStatistics, source2.meanStatistics(), IOStatisticsBinding::aggregateMeanStatistics, MeanStatistic::copy);
        return true;
    }

    @Override
    public synchronized Map<String, Long> counters() {
        return this.counters;
    }

    @Override
    public synchronized Map<String, Long> gauges() {
        return this.gauges;
    }

    @Override
    public synchronized Map<String, Long> minimums() {
        return this.minimums;
    }

    @Override
    public synchronized Map<String, Long> maximums() {
        return this.maximums;
    }

    @Override
    public synchronized Map<String, MeanStatistic> meanStatistics() {
        return this.meanStatistics;
    }

    public String toString() {
        return IOStatisticsLogging.ioStatisticsToString(this);
    }

    public static JsonSerialization<IOStatisticsSnapshot> serializer() {
        return new JsonSerialization<IOStatisticsSnapshot>(IOStatisticsSnapshot.class, false, true);
    }

    private synchronized void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(new TreeMap<String, Long>(this.counters));
        s2.writeObject(new TreeMap<String, Long>(this.gauges));
        s2.writeObject(new TreeMap<String, Long>(this.minimums));
        s2.writeObject(new TreeMap<String, Long>(this.maximums));
        s2.writeObject(new TreeMap<String, MeanStatistic>(this.meanStatistics));
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.counters = new ConcurrentHashMap<String, Long>((TreeMap)s2.readObject());
        this.gauges = new ConcurrentHashMap<String, Long>((TreeMap)s2.readObject());
        this.minimums = new ConcurrentHashMap<String, Long>((TreeMap)s2.readObject());
        this.maximums = new ConcurrentHashMap<String, Long>((TreeMap)s2.readObject());
        this.meanStatistics = new ConcurrentHashMap<String, MeanStatistic>((TreeMap)s2.readObject());
    }

    public static List<Class> requiredSerializationClasses() {
        return Arrays.stream(DESERIALIZATION_CLASSES).collect(Collectors.toList());
    }
}

