---
id: 'contribution'
title: '概述'
---

欢迎社区中的每一位用户和开发者成为贡献者。无论是报告问题、改进文档、提交代码，还是提供技术支持，您的参与都将有助于使其变得更好。

## 贡献方向

对 Apache Fesod (Incubating) 贡献，贡献方向有很多:

- 修复错别字
- 修复 Bug
- 删除冗余代码
- 添加测试用例
- 增强功能
- 添加注释以提升代码可读性
- 优化代码结构
- 改进或完善文档

### 原则

- 任何有助于项目改进的 PR 都值得鼓励！
- 贡献一个新的功能，请先在 `issue` 或 `discussion` 中提出和讨论。我们不会合并**未经讨论和确认的**的功能

## 贡献流程

### 查找任务

找到您感兴趣的问题！在我们的 GitHub 仓库问题列表中，我们经常发布带有`good first issue`或`help wanted`标签的问题。这些问题欢迎贡献者的帮助。其中，`good first issues`通常门槛较低，适合初学者参与。

当然，如果您有好的想法，也可以直接在 GitHub 讨论区提出，或联系社区成员。

### 讨论

请参考[问题反馈](./feedback.md)来创建一个问题或讨论，并努力达成共识。

**注意**：如果申请分配这个问题时，请注意这并非简单的“请分配给我”，您需要阐述对问题的理解、设计方案，并在可能的情况下提供您的概念验证代码。

### 实现

根据问题中商定的方案实施变更。

- 仅在方案达成共识时才开始实施工作（例如：您已被指派处理该工单）
- 若您是新成员，可参考[代码贡献指南](./contribution/contribute-code.md)来搭建开发环境。

### 审核

创建拉取请求并与审核者协作。

- 确保不包含无关或不必要的格式调整。
- 在提交 PR 之后会触发 CI，请确保通过 CI 检查。
- 请确保测试通过。
- 请勿解决讨论。

### 合并

社区 committer 需要根据[Code Review指南](./contribution/code-review-guide.md)中的指南，负责检查贡献是否满足要求，并将代码合并到代码库中。

## 贡献代码

所有改进均可通过 Pull Request (PR) 实现。在提交 Pull Request 前，请参考[代码贡献指南](./contribution/contribute-code.md)了解如何贡献代码。

## 测试用例贡献

任何测试用例的贡献都值得鼓励，尤其是单元测试。建议在对应模块的 `test` 目录中创建 `XXXTest.java` 文件，推荐使用 `JUnit5` 框架。

## 贡献文档

文档是 Apache Fesod (Incubating) 官方网站的重要构建内容，是项目与社区之间的重要桥梁。请参考[文档贡献指南](./contribution/contribute-doc.md)了解如何贡献文档。

## 其他参与方式

除了直接贡献代码，以下方式同样是对 Apache Fesod (Incubating) 的宝贵支持：

- 回答其他用户的问题。
- 帮助审阅他人的 PR。
- 提出改进建议。
- 撰写技术博客，宣传 Apache Fesod (Incubating)。
- 在社区中分享项目相关知识。
