/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.iceberg.hadoop.HadoopStreams;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class FileIOFSUtil {
    private FileIOFSUtil() {
    }

    static class OutputFileSystem
    extends NullFileSystem {
        private final OutputFile outputFile;
        private final Path outPath;

        OutputFileSystem(OutputFile outputFile) {
            this.outputFile = outputFile;
            this.outPath = new Path(outputFile.location());
        }

        public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
            Preconditions.checkArgument((boolean)f.equals((Object)this.outPath), (Object)String.format("Input %s does not equal expected %s", f, this.outPath));
            PositionOutputStream outputStream = overwrite ? this.outputFile.createOrOverwrite() : this.outputFile.create();
            return new FSDataOutputStream((OutputStream)outputStream, null);
        }

        @Override
        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return this.create(f, overwrite);
        }
    }

    static class InputFileSystem
    extends NullFileSystem {
        private final InputFile inputFile;
        private final Path inputPath;

        InputFileSystem(InputFile inputFile) {
            this.inputFile = inputFile;
            this.inputPath = new Path(inputFile.location());
        }

        @Override
        public FSDataInputStream open(Path f) throws IOException {
            Preconditions.checkArgument((boolean)f.equals((Object)this.inputPath), (Object)String.format("Input %s does not equal expected %s", f, this.inputPath));
            return new FSDataInputStream((InputStream)HadoopStreams.wrap((SeekableInputStream)this.inputFile.newStream()));
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return this.open(f);
        }
    }

    private static class NullFileSystem
    extends FileSystem {
        private NullFileSystem() {
        }

        public URI getUri() {
            throw new UnsupportedOperationException();
        }

        public FSDataInputStream open(Path f) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean rename(Path src, Path dst) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
            throw new UnsupportedOperationException();
        }

        public void setWorkingDirectory(Path new_dir) {
            throw new UnsupportedOperationException();
        }

        public Path getWorkingDirectory() {
            throw new UnsupportedOperationException();
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

