/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public abstract class UnsafeWriter {
    protected final BufferHolder holder;
    protected int startingOffset;

    protected UnsafeWriter(BufferHolder holder) {
        this.holder = holder;
    }

    public final BufferHolder getBufferHolder() {
        return this.holder;
    }

    public final byte[] getBuffer() {
        return this.holder.getBuffer();
    }

    public final void reset() {
        this.holder.reset();
    }

    public final int totalSize() {
        return this.holder.totalSize();
    }

    public final void grow(int neededSize) {
        this.holder.grow(neededSize);
    }

    public final int cursor() {
        return this.holder.getCursor();
    }

    public final void increaseCursor(int val) {
        this.holder.increaseCursor(val);
    }

    public final void setOffsetAndSizeFromPreviousCursor(int ordinal, int previousCursor) {
        this.setOffsetAndSize(ordinal, previousCursor, this.cursor() - previousCursor);
    }

    protected void setOffsetAndSize(int ordinal, int size) {
        this.setOffsetAndSize(ordinal, this.cursor(), size);
    }

    protected void setOffsetAndSize(int ordinal, int currentCursor, int size) {
        long relativeOffset = currentCursor - this.startingOffset;
        long offsetAndSize = relativeOffset << 32 | (long)size;
        this.write(ordinal, offsetAndSize);
    }

    protected final void zeroOutPaddingBytes(int numBytes) {
        if ((numBytes & 7) > 0) {
            Platform.putLong((Object)this.getBuffer(), (long)(this.cursor() + (numBytes >> 3 << 3)), (long)0L);
        }
    }

    public abstract void setNull1Bytes(int var1);

    public abstract void setNull2Bytes(int var1);

    public abstract void setNull4Bytes(int var1);

    public abstract void setNull8Bytes(int var1);

    public abstract void write(int var1, boolean var2);

    public abstract void write(int var1, byte var2);

    public abstract void write(int var1, short var2);

    public abstract void write(int var1, int var2);

    public abstract void write(int var1, long var2);

    public abstract void write(int var1, float var2);

    public abstract void write(int var1, double var2);

    public abstract void write(int var1, Decimal var2, int var3, int var4);

    public final void write(int ordinal, UTF8String input) {
        this.writeUnalignedBytes(ordinal, input.getBaseObject(), input.getBaseOffset(), input.numBytes());
    }

    public final void write(int ordinal, byte[] input) {
        this.write(ordinal, input, 0, input.length);
    }

    public final void write(int ordinal, byte[] input, int offset, int numBytes) {
        this.writeUnalignedBytes(ordinal, input, Platform.BYTE_ARRAY_OFFSET + offset, numBytes);
    }

    private void writeUnalignedBytes(int ordinal, Object baseObject, long baseOffset, int numBytes) {
        int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        this.grow(roundedSize);
        this.zeroOutPaddingBytes(numBytes);
        Platform.copyMemory((Object)baseObject, (long)baseOffset, (Object)this.getBuffer(), (long)this.cursor(), (long)numBytes);
        this.setOffsetAndSize(ordinal, numBytes);
        this.increaseCursor(roundedSize);
    }

    public void write(int ordinal, CalendarInterval input) {
        this.grow(16);
        if (input == null) {
            BitSetMethods.set((Object)this.getBuffer(), (long)this.startingOffset, (int)ordinal);
        } else {
            Platform.putInt((Object)this.getBuffer(), (long)this.cursor(), (int)input.months);
            Platform.putInt((Object)this.getBuffer(), (long)(this.cursor() + 4), (int)input.days);
            Platform.putLong((Object)this.getBuffer(), (long)(this.cursor() + 8), (long)input.microseconds);
        }
        this.setOffsetAndSize(ordinal, 16);
        this.increaseCursor(16);
    }

    public final void write(int ordinal, UnsafeRow row) {
        this.writeAlignedBytes(ordinal, row.getBaseObject(), row.getBaseOffset(), row.getSizeInBytes());
    }

    public final void write(int ordinal, UnsafeMapData map) {
        this.writeAlignedBytes(ordinal, map.getBaseObject(), map.getBaseOffset(), map.getSizeInBytes());
    }

    public final void write(UnsafeArrayData array) {
        int numBytes = array.getSizeInBytes();
        this.grow(numBytes);
        Platform.copyMemory((Object)array.getBaseObject(), (long)array.getBaseOffset(), (Object)this.getBuffer(), (long)this.cursor(), (long)numBytes);
        this.increaseCursor(numBytes);
    }

    private void writeAlignedBytes(int ordinal, Object baseObject, long baseOffset, int numBytes) {
        this.grow(numBytes);
        Platform.copyMemory((Object)baseObject, (long)baseOffset, (Object)this.getBuffer(), (long)this.cursor(), (long)numBytes);
        this.setOffsetAndSize(ordinal, numBytes);
        this.increaseCursor(numBytes);
    }

    protected final void writeBoolean(long offset, boolean value) {
        Platform.putBoolean((Object)this.getBuffer(), (long)offset, (boolean)value);
    }

    protected final void writeByte(long offset, byte value) {
        Platform.putByte((Object)this.getBuffer(), (long)offset, (byte)value);
    }

    protected final void writeShort(long offset, short value) {
        Platform.putShort((Object)this.getBuffer(), (long)offset, (short)value);
    }

    protected final void writeInt(long offset, int value) {
        Platform.putInt((Object)this.getBuffer(), (long)offset, (int)value);
    }

    protected final void writeLong(long offset, long value) {
        Platform.putLong((Object)this.getBuffer(), (long)offset, (long)value);
    }

    protected final void writeFloat(long offset, float value) {
        Platform.putFloat((Object)this.getBuffer(), (long)offset, (float)value);
    }

    protected final void writeDouble(long offset, double value) {
        Platform.putDouble((Object)this.getBuffer(), (long)offset, (double)value);
    }
}

