/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timeExp[, fmt]) - Returns the UNIX timestamp of the given time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string which is returned as a UNIX timestamp.\n      * fmt - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n              Default value is \"yyyy-MM-dd HH:mm:ss\". See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n              for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460098800\n  ", group="datetime_funcs", since="1.6.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0014)\u0001VB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011!Y\u0005A!f\u0001\n\u0003a\u0005\u0002C.\u0001\u0005#\u0005\u000b\u0011B'\t\u0011q\u0003!Q3A\u0005\u0002uC\u0001\"\u0019\u0001\u0003\u0012\u0003\u0006IA\u0018\u0005\u0006E\u0002!\ta\u0019\u0005\u0006E\u0002!\t!\u001b\u0005\u0006Y\u0002!\t\u0005\u0012\u0005\u0006[\u0002!\t\u0005\u0012\u0005\u0006]\u0002!\te\u001c\u0005\u0006E\u0002!\t\u0001\u001e\u0005\u0006o\u0002!\t\u0005\u001f\u0005\u0006s\u0002!\tF\u001f\u0005\t\u007f\u0002\t\t\u0011\"\u0001\u0002\u0002!I\u00111\u0002\u0001\u0012\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003G\u0001\u0011\u0013!C\u0001\u0003\u001bA\u0011\"!\n\u0001#\u0003%\t!a\n\t\u0013\u0005-\u0002!%A\u0005\u0002\u00055\u0002\"CA\u0019\u0001\u0005\u0005I\u0011IA\u001a\u0011%\t\u0019\u0005AA\u0001\n\u0003\t)\u0005C\u0005\u0002N\u0001\t\t\u0011\"\u0001\u0002P!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0013Q\f\u0005\n\u0003W\u0002\u0011\u0011!C\u0001\u0003[B\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\b\u0013\u0005u\u0005&!A\t\u0002\u0005}e\u0001C\u0014)\u0003\u0003E\t!!)\t\r\tlB\u0011AAX\u0011%\t\t,HA\u0001\n\u000b\n\u0019\fC\u0005\u00026v\t\t\u0011\"!\u00028\"I\u0011\u0011Y\u000f\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003\u0007l\u0012\u0013!C\u0001\u0003[A\u0011\"!2\u001e\u0003\u0003%\t)a2\t\u0013\u0005UW$%A\u0005\u0002\u0005\u001d\u0002\"CAl;E\u0005I\u0011AA\u0017\u0011%\tI.HA\u0001\n\u0013\tYNA\bU_Vs\u0017\u000e\u001f+j[\u0016\u001cH/Y7q\u0015\tI#&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0016-\u0003!\u0019\u0017\r^1msN$(BA\u0017/\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003_A\nQa\u001d9be.T!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO\u000e\u00011\u0003\u0002\u00017u\u0001\u0003\"a\u000e\u001d\u000e\u0003!J!!\u000f\u0015\u0003\u0011Us\u0017\u000e\u001f+j[\u0016\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002<\u0003&\u0011!\t\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\bi&lW-\u0012=q+\u0005)\u0005CA\u001cG\u0013\t9\u0005F\u0001\u0006FqB\u0014Xm]:j_:\f\u0001\u0002^5nK\u0016C\b\u000fI\u0001\u0007M>\u0014X.\u0019;\u0002\u000f\u0019|'/\\1uA\u0005QA/[7f5>tW-\u00133\u0016\u00035\u00032a\u000f(Q\u0013\tyEH\u0001\u0004PaRLwN\u001c\t\u0003#bs!A\u0015,\u0011\u0005McT\"\u0001+\u000b\u0005U#\u0014A\u0002\u001fs_>$h(\u0003\u0002Xy\u00051\u0001K]3eK\u001aL!!\u0017.\u0003\rM#(/\u001b8h\u0015\t9F(A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012A\u0018\t\u0003w}K!\u0001\u0019\u001f\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"R\u0001Z3gO\"\u0004\"a\u000e\u0001\t\u000b\rK\u0001\u0019A#\t\u000b%K\u0001\u0019A#\t\u000f-K\u0001\u0013!a\u0001\u001b\"9A,\u0003I\u0001\u0002\u0004qFc\u00013kW\")1I\u0003a\u0001\u000b\")\u0011J\u0003a\u0001\u000b\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\t\u00018\u000f\u0005\u00028c&\u0011!\u000f\u000b\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:DQaS\u0007A\u0002A#\"\u0001Z;\t\u000bYt\u0001\u0019A#\u0002\tQLW.Z\u0001\u000baJ,G\u000f^=OC6,W#\u0001)\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u00013|{\")A\u0010\u0005a\u0001\u000b\u00069a.Z<MK\u001a$\b\"\u0002@\u0011\u0001\u0004)\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\nI\u0006\r\u0011QAA\u0004\u0003\u0013AqaQ\t\u0011\u0002\u0003\u0007Q\tC\u0004J#A\u0005\t\u0019A#\t\u000f-\u000b\u0002\u0013!a\u0001\u001b\"9A,\u0005I\u0001\u0002\u0004q\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fQ3!RA\tW\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000fy\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0012q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tICK\u0002N\u0003#\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u00020)\u001aa,!\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\tAA[1wC&\u0019\u0011,!\u000f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0003cA\u001e\u0002J%\u0019\u00111\n\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E\u0013q\u000b\t\u0004w\u0005M\u0013bAA+y\t\u0019\u0011I\\=\t\u0013\u0005e\u0003$!AA\u0002\u0005\u001d\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002`A1\u0011\u0011MA4\u0003#j!!a\u0019\u000b\u0007\u0005\u0015D(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001b\u0002d\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rq\u0016q\u000e\u0005\n\u00033R\u0012\u0011!a\u0001\u0003#\na!Z9vC2\u001cHc\u00010\u0002v!I\u0011\u0011L\u000e\u0002\u0002\u0003\u0007\u0011\u0011\u000b\u0015\u0018\u0001\u0005e\u0014qPAA\u0003\u000b\u000b9)a#\u0002\u000e\u0006E\u00151SAL\u00033\u00032aNA>\u0013\r\ti\b\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019)\u0001$`\rVs5i\u0018\u0015uS6,W\t\u001f9\\Y\u00012W\u000e^/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAUs\u0015\n\u0017\u0011uS6,7\u000f^1na\u0002zg\r\t;iK\u0002:\u0017N^3oAQLW.\u001a\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAE\u0003\r\u0015\"\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uS6,W\t\u001f9![\u0001\n\u0005\u0005Z1uK>\"\u0018.\\3ti\u0006l\u0007\u000fI8sAM$(/\u001b8hA]D\u0017n\u00195!SN\u0004#/\u001a;ve:,G\rI1tA\u0005\u0004SKT%YAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011g[R\u0004S\u0006\t#bi\u0016|C/[7fA\u0019|'/\\1uAA\fG\u000f^3s]\u0002\"x\u000e\t4pY2|wO\f\u0011JO:|'/\u001a3!S\u001a\u0004\u0003\r^5nK\u0016C\b\u000f\u0019\u0011jg\u0002rw\u000e\u001e\u0011bAM$(/\u001b8h])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"UMZ1vYR\u0004c/\u00197vK\u0002J7\u000f\t\u0012zsfLX&T'.I\u0012\u0004\u0003\n\u0013\u001en[j\u001a8O\t\u0018!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M\fH.\f:fM6\"\u0017\r^3uS6,W\u0006]1ui\u0016\u0014hN\f5u[2\u0014c\bR1uKRLW.\u001a\u0011QCR$XM\u001d8ty=\ngH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t4pe\u00022\u0018\r\\5eA\u0011\fG/\u001a\u0011b]\u0012\u0004C/[7fA\u0019|'/\\1uAA\fG\u000f^3s]Nt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a$\u0002-*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\u0002D'\f\u00199O1\u0002s%_=zs6jU*\f3eO%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u001b7aAJ\u0004\b\u000f\u00191\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAK\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!a'\u0002\u000bErcG\f\u0019\u0002\u001fQ{WK\\5y)&lWm\u001d;b[B\u0004\"aN\u000f\u0014\tu\t\u0019\u000b\u0011\t\n\u0003K\u000bY+R#N=\u0012l!!a*\u000b\u0007\u0005%F(A\u0004sk:$\u0018.\\3\n\t\u00055\u0016q\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCAAP\u0003!!xn\u0015;sS:<GCAA\u001b\u0003\u0015\t\u0007\u000f\u001d7z)%!\u0017\u0011XA^\u0003{\u000by\fC\u0003DA\u0001\u0007Q\tC\u0003JA\u0001\u0007Q\tC\u0004LAA\u0005\t\u0019A'\t\u000fq\u0003\u0003\u0013!a\u0001=\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$B!!3\u0002RB!1HTAf!\u001dY\u0014QZ#F\u001bzK1!a4=\u0005\u0019!V\u000f\u001d7fi!A\u00111[\u0012\u0002\u0002\u0003\u0007A-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u0006sK\u0006$'+Z:pYZ,GCAAo!\u0011\t9$a8\n\t\u0005\u0005\u0018\u0011\b\u0002\u0007\u001f\nTWm\u0019;")
public class ToUnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return ToUnixTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ToUnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<String>, Object>> unapply(ToUnixTimestamp toUnixTimestamp) {
        return ToUnixTimestamp$.MODULE$.unapply(toUnixTimestamp);
    }

    public static boolean apply$default$4() {
        return ToUnixTimestamp$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return ToUnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<String>, Object>, ToUnixTimestamp> tupled() {
        return ToUnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, Function1<Object, ToUnixTimestamp>>>> curried() {
        return ToUnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public String prettyName() {
        return "to_unix_timestamp";
    }

    @Override
    public ToUnixTimestamp withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    public ToUnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        return new ToUnixTimestamp(timeExp, format, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ToUnixTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeExp();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToUnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToUnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToUnixTimestamp toUnixTimestamp = (ToUnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = toUnixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = toUnixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = toUnixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.failOnError() != toUnixTimestamp.failOnError()) return false;
        if (!toUnixTimestamp.canEqual(this)) return false;
        return true;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public ToUnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

