/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('{\"teacher\": \"Alice\", \"student\": [{\"name\": \"Bob\", \"rank\": 1}, {\"name\": \"Charlie\", \"rank\": 2}]}', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001\u0002\u001a4\u0001\u0002C\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\tS\u0002\u0011\t\u0012)A\u0005G\"A!\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005{\u0001\tE\t\u0015!\u0003m\u0011!Y\bA!f\u0001\n\u0003a\b\"CA\u0001\u0001\tE\t\u0015!\u0003~\u0011)\t\u0019\u0001\u0001BK\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003\u001b\u0001!\u0011#Q\u0001\n\u0005\u001d\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\t\u0003;\u0001!\u0019!C\u0001E\"9\u0011q\u0004\u0001!\u0002\u0013\u0019\u0007bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003W\u0001AQIA\u0017\u0011\u001d\ty\u0001\u0001C\u0001\u0003SBq!a\u0004\u0001\t\u0003\t\t\bC\u0004\u0002\u0010\u0001!\t!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\"Q\u0011q\u0012\u0001\t\u0006\u0004%\t!!%\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005\u001d\u0007bBAe\u0001\u0001\u0006Ia\u001e\u0005\u000b\u0003\u0017\u0004\u0001R1A\u0005\u0002\u00055\u0007BBAv\u0001\u0011\u0005#\rC\u0004\u0002n\u0002!\t%a<\t\u000f\u0005M\b\u0001\"\u0011\u0002v\"9!\u0011\u0001\u0001\u0005B\t\r\u0001B\u0002\u001d\u0001\t\u0003\n9\rC\u0004\u0003\u000e\u0001!\t%a2\t\u000f\t=\u0001\u0001\"\u0015\u0003\u0012!I!q\u0003\u0001\u0002\u0002\u0013\u0005!\u0011\u0004\u0005\n\u0005G\u0001\u0011\u0013!C\u0001\u0005KA\u0011Ba\u000f\u0001#\u0003%\tA!\u0010\t\u0013\t\u0005\u0003!%A\u0005\u0002\t\r\u0003\"\u0003B$\u0001E\u0005I\u0011\u0001B%\u0011%\u0011i\u0005AA\u0001\n\u0003\u0012y\u0005C\u0005\u0003V\u0001\t\t\u0011\"\u0001\u0003X!I!q\f\u0001\u0002\u0002\u0013\u0005!\u0011\r\u0005\n\u0005O\u0002\u0011\u0011!C!\u0005SB\u0011B!\u001e\u0001\u0003\u0003%\tAa\u001e\t\u0013\tm\u0004!!A\u0005B\tu\u0004B\u0004BA\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\u0005%1Q\u0004\n\u0005K\u001b\u0014\u0011!E\u0001\u0005O3\u0001BM\u001a\u0002\u0002#\u0005!\u0011\u0016\u0005\b\u0003\u001fQC\u0011\u0001B\\\u0011%\u0011ILKA\u0001\n\u000b\u0012Y\fC\u0005\u0003>*\n\t\u0011\"!\u0003@\"I!\u0011\u001a\u0016\u0012\u0002\u0013\u0005!\u0011\n\u0005\n\u0005\u0017T\u0013\u0011!CA\u0005\u001bD\u0011Ba7+#\u0003%\tA!\u0013\t\u0013\tu'&!A\u0005\n\t}'!\u0004&t_:$vn\u0015;sk\u000e$8O\u0003\u00025k\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1t'\u0001\u0005dCR\fG._:u\u0015\tA\u0014(A\u0002tc2T!AO\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0002\u0001'!\u0001\u0011)\u0012%O#bs\u0006C\u0001\"D\u001b\u0005\u0019\u0014B\u0001#4\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\"G\u0013\t95GA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0011\nT\u0007\u0002\u0015*\u00111jM\u0001\bG>$WmZ3o\u0013\ti%JA\bD_\u0012,w-\u001a8GC2d'-Y2l!\t\u0011u*\u0003\u0002Qg\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005I+fB\u0001\"T\u0013\t!6'A\u0004qC\u000e\\\u0017mZ3\n\u0005Y;&A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003)N\u0002\"!\u0017/\u000e\u0003iS\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002Z?&\u0011\u0001M\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007g\u000eDW-\\1\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ\u001c\u0002\u000bQL\b/Z:\n\u0005!,'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u00059q\u000e\u001d;j_:\u001cX#\u00017\u0011\t5$xo\u001e\b\u0003]J\u0004\"a\u001c.\u000e\u0003AT!!] \u0002\rq\u0012xn\u001c;?\u0013\t\u0019(,\u0001\u0004Qe\u0016$WMZ\u0005\u0003kZ\u00141!T1q\u0015\t\u0019(\f\u0005\u0002nq&\u0011\u0011P\u001e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011=\u0004H/[8og\u0002\nQa\u00195jY\u0012,\u0012! \t\u0003\u0005zL!a`\u001a\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u000bi&lWMW8oK&#WCAA\u0004!\u0011I\u0016\u0011B<\n\u0007\u0005-!L\u0001\u0004PaRLwN\\\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0001C\u0001\"\u0001\u0011\u0015\t\u0017\u00021\u0001d\u0011\u0015Q\u0017\u00021\u0001m\u0011\u0015Y\u0018\u00021\u0001~\u0011%\t\u0019!\u0003I\u0001\u0002\u0004\t9!\u0001\bok2d\u0017M\u00197f'\u000eDW-\\1\u0002\u001f9,H\u000e\\1cY\u0016\u001c6\r[3nC\u0002\n\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003K\u00012!WA\u0014\u0013\r\tIC\u0017\u0002\b\u0005>|G.Z1o\u0003Qqw\u000eZ3QCR$XM\u001d8t\u0013:$XM\u001d8bYR\u0011\u0011q\u0006\t\u0007\u0003c\tI$a\u0010\u000f\t\u0005M\u0012q\u0007\b\u0004_\u0006U\u0012\"A.\n\u0005QS\u0016\u0002BA\u001e\u0003{\u00111aU3r\u0015\t!&\f\u0005\u0003\u0002B\u0005\rd\u0002BA\"\u0003;rA!!\u0012\u0002Z9!\u0011qIA,\u001d\u0011\tI%!\u0016\u000f\t\u0005-\u00131\u000b\b\u0005\u0003\u001b\n\tFD\u0002p\u0003\u001fJ\u0011AP\u0005\u0003yuJ!AO\u001e\n\u0005aJ\u0014B\u0001\u001c8\u0013\r\tY&N\u0001\u0006iJ,Wm]\u0005\u0005\u0003?\n\t'A\u0006Ue\u0016,\u0007+\u0019;uKJt'bAA.k%!\u0011QMA4\u0005-!&/Z3QCR$XM\u001d8\u000b\t\u0005}\u0013\u0011\r\u000b\t\u0003'\tY'!\u001c\u0002p!)1P\u0004a\u0001{\")\u0011M\u0004a\u0001{\")!N\u0004a\u0001YR1\u00111CA:\u0003kBQa_\bA\u0002uDQ!Y\bA\u0002u$\u0002\"a\u0005\u0002z\u0005m\u0014Q\u0010\u0005\u0006wB\u0001\r! \u0005\u0006CB\u0001\r! \u0005\u0006UB\u0001\r!`\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013+\u0014\u0001C1oC2L8/[:\n\t\u00055\u0015q\u0011\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006I1m\u001c8wKJ$XM]\u000b\u0003\u0003'\u0003r!WAK\u00033\u000b9+C\u0002\u0002\u0018j\u0013\u0011BR;oGRLwN\\\u0019\u0011\r\u0005E\u00121TAP\u0013\u0011\ti*!\u0010\u0003\u0011%#XM]1u_J\u0004B!!)\u0002$6\tQ'C\u0002\u0002&V\u00121\"\u00138uKJt\u0017\r\u001c*poJ)\u0011\u0011\u00160\u0002.\u001a1\u00111\u0016\u0001\u0001\u0003O\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0003mC:<'BAA\\\u0003\u0011Q\u0017M^1\n\t\u0005m\u0016\u0011\u0017\u0002\u0007\u001f\nTWm\u0019;)\u0007I\ty\fE\u0002Z\u0003\u0003L1!a1[\u0005%!(/\u00198tS\u0016tG/A\noC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H-F\u0001x\u0003Qq\u0017-\\3PM\u000e{'O];qiJ+7m\u001c:eA\u00051\u0001/\u0019:tKJ,\"!a4\u0011\r\u0005E\u0017q[An\u001b\t\t\u0019NC\u0002\u0002VV\nA!\u001e;jY&!\u0011\u0011\\Aj\u0005E1\u0015-\u001b7ve\u0016\u001c\u0016MZ3QCJ\u001cXM\u001d\t\u0005\u0003;\f)/\u0004\u0002\u0002`*\u0019a-!9\u000b\u0007\u0005\r\u0018(\u0001\u0004v]N\fg-Z\u0005\u0005\u0003O\fyN\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD3!FA`\u0003!!\u0017\r^1UsB,\u0017\u0001D<ji\"$\u0016.\\3[_:,GcA#\u0002r\"1\u00111A\fA\u0002]\fAB\\;mYN\u000bg-Z#wC2$B!a>\u0002~B\u0019\u0011,!?\n\u0007\u0005m(LA\u0002B]fDq!a@\u0019\u0001\u0004\t90\u0001\u0003kg>t\u0017AC5oaV$H+\u001f9fgV\u0011!Q\u0001\t\u0007\u0003c\tIDa\u0002\u0011\u0007\u0011\u0014I!C\u0002\u0003\f\u0015\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003'\u0011\u0019\u0002\u0003\u0004\u0003\u0016q\u0001\r!`\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z))\t\u0019Ba\u0007\u0003\u001e\t}!\u0011\u0005\u0005\bCv\u0001\n\u00111\u0001d\u0011\u001dQW\u0004%AA\u00021Dqa_\u000f\u0011\u0002\u0003\u0007Q\u0010C\u0005\u0002\u0004u\u0001\n\u00111\u0001\u0002\b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0014U\r\u0019'\u0011F\u0016\u0003\u0005W\u0001BA!\f\u000385\u0011!q\u0006\u0006\u0005\u0005c\u0011\u0019$A\u0005v]\u000eDWmY6fI*\u0019!Q\u0007.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003:\t=\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B U\ra'\u0011F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)EK\u0002~\u0005S\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003L)\"\u0011q\u0001B\u0015\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u000b\t\u0005\u0003_\u0013\u0019&C\u0002z\u0003c\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u0017\u0011\u0007e\u0013Y&C\u0002\u0003^i\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a>\u0003d!I!Q\r\u0013\u0002\u0002\u0003\u0007!\u0011L\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t-\u0004C\u0002B7\u0005g\n90\u0004\u0002\u0003p)\u0019!\u0011\u000f.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\n=\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\"\u0011\u0010\u0005\n\u0005K2\u0013\u0011!a\u0001\u0003o\fa!Z9vC2\u001cH\u0003BA\u0013\u0005\u007fB\u0011B!\u001a(\u0003\u0003\u0005\r!a>\u00023M,\b/\u001a:%G\",7m[%oaV$H)\u0019;b)f\u0004Xm]\u0005\u0004\u0003\u007fz\u0005f\u0005\u0001\u0003\b\n5%q\u0012BJ\u0005+\u0013IJa'\u0003 \n\u0005\u0006c\u0001\"\u0003\n&\u0019!1R\u001a\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011S\u0001c?\u001a+fjQ0)UN|gn\u0015;sY\u0001\u001a8\r[3nCnc\u0003e\u001c9uS>t7/X\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\rI:ueV\u001cG\u000f\t<bYV,\u0007e^5uQ\u0002\"\b.\u001a\u0011hSZ,g\u000e\t1kg>t7\u000b\u001e:aA\u0005tG\r\t1tG\",W.\u00191/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001BL\u0003\u0011\r\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|E\u0005\u0014#(\r\u0017!E\t\u0014#\b\r\u00189{\u001eb\u0003eJ1!\u0013:#F\u0006\t2!\t>+&\tT#(SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#uEb#E\u0019\u0012;a9BTP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(w\n\"\u0018.\\3#u\t\u0012dg\f\u00199_I\u0002\u0014'\u000e\u0012~O1\u0002s\u0005^5nK\u0002\"\u0016.\\3ti\u0006l\u0007o\n\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uS6,'E\u000f\u001a1cUj\u0003\u0007O\u00173m\u0001\u0002\u0004G\u000f\u00191uA\u0002TP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(w\n\"X-Y2iKJ\u0014#\b\t\u0012BY&\u001cWM\t\u0017!EM$X\u000fZ3oi\nR\u0004eW>#]\u0006lWM\t\u001e!E\t{'M\t\u0017!EI\fgn\u001b\u0012;AEjH\u0006I>#]\u0006lWM\t\u001e!E\rC\u0017M\u001d7jK\nb\u0003E\t:b].\u0014#\b\t\u001a~;v<C\u0006I\u0014T)J+6\t\u0016\u001fuK\u0006\u001c\u0007.\u001a:;AM#&+\u0013(HY\u0001\u001aH/\u001e3f]RT\u0004%\u0011*S\u0003fc4\u000b\u0016*V\u0007Rcd.Y7fu\u0001\u001aFKU%O\u000f2\u0002#/\u00198lu\u0001Je\n\u0016 ?}\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#i\u0016\f7\r[3sEi\u0012\u0013\t\\5dK\nb#e\u001d;vI\u0016tGO\t\u001e\\w\nr\u0017-\\3#u\t\u0012uN\u0019\u0012-EI\fgn\u001b\u0012;cud3P\t8b[\u0016\u0014#HI\"iCJd\u0017.\u001a\u0012-EI\fgn\u001b\u0012;eulVP\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011i*\u0001\u0006kg>twLZ;oGN\fQa]5oG\u0016\f#Aa)\u0002\u000bIr#G\f\u0019\u0002\u001b)\u001bxN\u001c+p'R\u0014Xo\u0019;t!\t\u0011%f\u0005\u0003+\u0005Ws\u0006c\u0003BW\u0005g\u001bG.`A\u0004\u0003'i!Aa,\u000b\u0007\tE&,A\u0004sk:$\u0018.\\3\n\t\tU&q\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001BT\u0003!!xn\u0015;sS:<GC\u0001B)\u0003\u0015\t\u0007\u000f\u001d7z))\t\u0019B!1\u0003D\n\u0015'q\u0019\u0005\u0006C6\u0002\ra\u0019\u0005\u0006U6\u0002\r\u0001\u001c\u0005\u0006w6\u0002\r! \u0005\n\u0003\u0007i\u0003\u0013!a\u0001\u0003\u000f\tq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yMa6\u0011\u000be\u000bIA!5\u0011\u0011e\u0013\u0019n\u00197~\u0003\u000fI1A!6[\u0005\u0019!V\u000f\u001d7fi!I!\u0011\\\u0018\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u0006sK\u0006$'+Z:pYZ,GCAAW\u0001")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<UTF8String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private /* synthetic */ TypeCheckResult super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)new .colon.colon((Object)TreePattern$.MODULE$.JSON_TO_STRUCT(), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? (TypeCheckResult)ExprUtils$.MODULE$.checkJsonSchema(this.nullableSchema()).map((Function1 & Serializable & scala.Serializable)e -> new TypeCheckResult.TypeCheckFailure(e.getMessage())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$checkInputDataTypes()) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Input schema ").append(this.nullableSchema().catalogString()).append(" must be a struct, an array or a map.").toString());
        return typeCheckResult;
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? (InternalRow)rows.next() : null;
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getArray(0) : null;
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getMap(0) : null;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<UTF8String> parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Tuple2 tuple2;
                DataType dataType;
                ParseMode mode;
                JSONOptions parsedOptions = new JSONOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_json", mode);
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType, parsedOptions.columnNameOfCorruptRecord());
                    tuple2 = new Tuple2((Object)structType, (Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)structType.filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)JsonToStructs.$anonfun$parser$1(parsedOptions, x$12))))));
                } else {
                    StructField structField = new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$.$colon$colon((Object)structField)), (Object)dataType);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                StructType parserSchema = (StructType)tuple22._1();
                DataType actualSchema = (DataType)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                Tuple2 tuple24 = tuple23;
                StructType parserSchema2 = (StructType)tuple24._1();
                DataType actualSchema2 = (DataType)tuple24._2();
                JacksonParser rawParser = new JacksonParser(actualSchema2, parsedOptions, false, JacksonParser$.MODULE$.$lessinit$greater$default$4());
                Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record);
                this.parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<UTF8String> parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        return this.converter().apply(this.parser().parse((UTF8String)json));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        String string = dataType instanceof MapType ? "entries" : super.sql();
        return string;
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    @Override
    public JsonToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(JSONOptions parsedOptions$1, StructField x$12) {
        String string = x$12.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

